package com.icetech.cloudcenter.domain.pay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.List;

/**
 * @author wangzhiwei
 */
@Data
public class OpenParkVipDto implements Serializable {
    private Integer bizType=BizType.PARK_VIP_PAY.getBizType();
    /**
     * 用户id
     */
    private Integer userId;
    /**
     * 用户名称
     */
    private String username;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 第三方交易流水号
     */
    private String outTradeNo;
    /**
     * 产品id
     */
    private Integer productId;
    /**
     * 是否首次开通
     */
    private Boolean firstOpen;
    /**
     * 支付方式
     */
    private Integer payWay;

    /**
     * 开通用户
     */
    private List<String> userNames;
    /**
     * 下单时间
     */
    private Date orderTime = new Date();
}
