package com.icetech.cloudcenter.domain.pay;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 月卡续租
 * @author wangzhiwei
 */
@Data
public class MonthRenewCardDto implements Serializable {
    /**
     * 业务类型(不传)
     */
    private Integer bizType = BizType.MONTH_PAY.getBizType();

    /**
     * 续租月卡id
     */
    private Integer monthId;
    /**
     * 月卡产品id
     */
    private Integer productId;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 购买数量
     */
    private Integer buyNum;
    /**
     * 车位数
     */
    private Integer plotCount;
    /**
     * 产品面额（1个月2个月等）
     */
    private Integer duration;
    /**
     * 月卡开始时间(不传)
     */
    private Date startDate;
    /**
     * 月卡结束时间(不传)
     */
    private Date endDate;
    /**
     * 支付金额
     */
    private BigDecimal payMoney;
    /**
     * 支付方式(不传)  0 现金，1 银行卡 2：微信 3：支付宝
     */
    private Integer payMethod;
    /**
     * 支付渠道(不传) 1 云平台 2：App 3：公众号 4 小程序
     */
    private Integer payChannel;
    /**
     * 操作人(不传)
     */
    private Integer mpUserId;
    /**
     * 操作人
     */
    private String accountName;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 商户交易流水号
     */
    private String outTradeNo;
    /**
     * 支付时间
     */
    private Long payTime;


    /**
     * 手机号
     */
    private String phone;
    /**
     * 月卡申办性质，1个人 2公司
     */
    private Integer cardProperty = 1;
    /**
     * 用户姓名/公司名称
     */
    private String cardOwner;


    /**
     * 备注
     */
    private String remark;

    /**
     * 车主地址
     */
    private String mainAddress;
}
