package com.icetech.cloudcenter.domain.parkvip;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wangzhiwei
 */
@Data
public class ParkVipDto implements Serializable {
    /**
     * 车场id
     */
    private Long parkId;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 会员到期日期
     */
    private Date expirationTime;
    /**
     * 到期时间
     */
    private Integer expirationDayNum;
    /**
     * 通道数量
     */
    private Integer channelNum;
    /**
     * 单车场详情页 vip开通状态 1=未开通 2试用期 3=已开通 4=已过期
     * 多车场列表页 1=是已开通 其余都是未开通
     */
    private Integer status;

    /**
     * 热线号码
     */
    private String phoneNum;

    /**
     * 结账金额
     */
    private BigDecimal reportMoney;

    /**
     * 数据上报方式:1端云;2端网云;3纯云
     */
    private Integer dataCollection;
}
