package com.icetech.cloudcenter.domain.park.query;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * Description ParkTrusteeshipParam
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/6/29 10:40
 */
@Data
public class ParkTrusteeshipParam implements Serializable {

    /**
     * 车场id
     */
    private List<Long> parkIds;

    /**
     * 所属机构
     */
    private List<Integer> institutionIds;

    /**
     * 云坐席sip号
     */
    private String sipNum;

    /**
     * 托管模式：1-甲方自建坐席托管，2-知位自营坐席托管
     */
    private List<Integer> trusteeshipModels;

    /**
     * 有效开始日期
     */
    private String startTime;

    /**
     * 有效结束日期
     */
    private String endTime;

    /**
     * 托管状态,1-未生效，2-托管中，3-托管到期
     */
    private List<Integer> trusteeshipStatus;

    /**
     * 几天内到期
     */
    private Integer dueFewDays;

    /**
     * 页码
     */
    private Integer pageNo;
    /**
     * 分页大小
     */
    private Integer pageSize;
}
