package com.icetech.cloudcenter.domain.park.query;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 车位查询
 * @author wangzhiwei
 */
@Data
public class ParkQuery implements Serializable  {
    /**
     * 所属城市城市编码
     */
    private String city;
    /**
     *  1=停车场 2=地理位置
     */
    private Integer type = 1;
    /**
     * 经度
     */
    private Double lng;
    /**
     * 纬度
     */
    private Double lat;
    /**
     * 距离范围 单位公里
     */
    private Double rangeLocation = 5.0;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车场业态(为空查询全部) 0：其他 1：商超 2：商务写字楼 3：公共场馆 4 星级酒店 5：住宅 6：医院 7：学校 8：交通枢纽 9：商业综合体 10产业园 11路侧',
     */
    private List<Integer> parkProperty;
    /**
     * 租赁时段 1=全天 2=分时段
     */
    private Integer cardType;
    /**
     * 搜索词(为空查询全部)
     */
    private String key;
    /**
     * 页码
     */
    private Integer pageNo;
    /**
     * 分页大小
     */
    private Integer pageSize;


    //-------------------------------------
    /**
     * 转换查询条件不需要传 最小经度
     */
    private Double minX;
    /**
     * 转换查询条件不需要传 最大经度
     */
    private Double maxX;
    /**
     * 转换查询条件不需要传 最小纬度
     */
    private Double minY;
    /**
     * 转换查询条件不需要传 最大纬度
     */
    private Double maxY;
    /**
     * 转换查询条件不需要传 地址id
     */
    private Integer cityAreaId;
}
