package com.icetech.cloudcenter.domain.park;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/5/25 13:59
 * @description:
 */
@Data
public class ParkList implements Serializable {
    
    @ApiModelProperty(value = "停车场编号", required = true, example = "P1000001")
    private String parkCode;

    @ApiModelProperty(value = "停车场名称", required = true, example = "北辰停车场")
    private String parkName;

    @ApiModelProperty(value = "省份名称", required = true, example = "吉林")
    private String provinceName;

    @ApiModelProperty(value = "城市名称", required = true, example = "四平")
    private String cityName;

    @ApiModelProperty(value = "区名称", required = true, example = "双辽")
    private String districtName;

    @ApiModelProperty(value = "停车场地址", required = false, example = "茂林镇")
    private String address;

    @ApiModelProperty(value = "停车场总车位数", required = true, example = "10000")
    private Integer totalNum;

    @ApiModelProperty(value = "空车位", required = true, example = "100")
    private Integer freeSpace;

}
