package com.icetech.cloudcenter.domain.park;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 停车场系统配置表
 * </p>
 *
 * @author zhangpengzhan
 * @since 2021-05-26
 */
@Data
@NoArgsConstructor
public class ParkConfigInfoFind  implements Serializable{


    private Integer id;
    /**
     * 车场id
     */
    @TableField(exist = false)
    private String parkCode;

    private Integer parkId;

    /**
     * 是否同步数据（0不同步1同步；默认0）
     */
    private Integer isSync ;

    /**
     * 计费精度 0：分钟，1：秒 默认0
     */
    private Integer billPrecision  ;

    /**
     * 军警车是否免费停车 0：不免费 1：免费  默认1
     */
    private Integer isfreeSpecialcar  ;

    /**
     * 是否支持AB车管理 0：不支持 1：支持 默认0
     */
    private Integer issupAbmanage  ;

    /**
     * AB车场内切换**时间不收费，单位分钟
     */
    private Integer switchTm;

    /**
     * 支持多车位管理超时处理规则1，B车计费结束时间按A车出场时间收费 2，B车计费结束时间按B车出场时间收费  默认为1
     */
    private Integer switchType  ;

    /**
     * 免费时间内是否自动抬杆 0：不自动  1：自动 默认为1
     */
    private Integer isreleaseFreetm  ;

    /**
     * 是否上报车辆图片 0：不上报 1：上报 默认为1
     */
    private Integer isupimage   ;

    /**
     * 是否支持电子支付 0：不支持 1：支持 默认为1
     */
    private Integer isEpayment  ;

    /**
     * 聚合支付支付类型 微信/支付宝：WX_ALI_PAY 民生银行：CMBC_PAY  建设银行：CCB_PAY 农行：ABC_PAY  云纵: YZ_PAY 阿里平台支付: PARKING_PAY
     */
    private String epayment   ;

    /**
     * 是否支持无感支付 0：不支持 1：支持 默认为1
     */
    private Integer isNosenpayment  ;

    /**
     * 无感支付支付类型  银联无感支付：NO_SEN_UNION_PAY  建行无感支付：NO_SEN_CCB_PAY 农行无感支付：NO_SEN_ABC_PAY
     */
    private String nosenpayment;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 缴费后离场预留免费时长(单位分钟)
     */
    private Integer isfreeAfterpay  ;

    /**
     * 数据采集方式（相机直连、车场收费系统直连）、
     */
    private Integer dataCollection;

    /**
     * 云计费（支持、不支持）
     */
    private Integer cloudCharge  ;

    /**
     * 开电子发票1是2否 默认为2
     */
    private Integer isInvoice  ;

    /**
     * 免费时长是否计入停车费用1：是 2：否 默认为2
     */
    private Integer freetimeStatus ;

    /**
     * 是否补时 1是2否 默认为1
     */
    private Integer isFilltime  ;

    /**
     * 超时计费起始时间1末次缴费时间 2车辆入场时间 默认为1
     */
    private Integer overtimeBillType  ;

    /**
     * 是否允许二次使用免费时长 1不允许2允许 默认为1
     */
    private Integer isallowfreetmonce  ;

    /**
     * 收费是否抹零头1是2否 默认为1
     */
    private Integer isnotgetsmallchange  ;

    /**
     * 出场查无入场记录、支持固定收费1是2否  默认为2
     */
    private Integer isfixedfees  ;

    /**
     * 固定费用（单位元）
     */
    private Integer fixedfeevalue;

    /**
     * 大型车固定费用（单位元）
     */
    private Integer fixedFeeValueBig;

    /**
     * 计费规则版本编号（详见版本信息表定义)，默认为0
     */
    private Integer chargeVersionNum  ;

    /**
     * 是否允许无牌车重复入场，0：否 1：是， 默认为0
     */
    private Integer isNoplateRepeatenter  ;

    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是， 默认为0
     */
    private Integer isFullForbidenter  ;

    /**
     * 在车位满的情况下，是否禁止月卡车入内，0：否 1：是
     */
    private Integer isFullForbidmonthenter  ;

    /**
     * 在车位满的情况下，是否禁止VIP车入内，0：否 1：是
     */
    private Integer isFullForbidvipenter  ;

    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    private Integer isFullForbidreserventer  ;

    /**
     * 在车位满的情况下，是否禁止储值车入内，0：否 1：是
     */
    private Integer isFullForbidstoreenter  ;

    /**
     * 剩余多少空车位时，禁止入场，is_full_ forbidenter为1时不能为空
     */
    private Integer fullEmptynum  ;

    /**
     * 货币单位
     */
    private String moneyunitType ;

    /**
     * 新增月卡车是否计入总车位数1是 2 否 默认是2
     */
    private Integer isCardcount   ;

    /**
     * 车辆出入口停留多长时间监控坐席提醒
     */
    private Integer carenexTimelong ;

    /**
     * 是否特殊车场（存在进出共用一个通道的车场）0不是，1是 默认是0
     */
    private Integer isSpecialPark  ;

    /**
     * 如果是特殊车场配置入场到出场最小时间值，以秒为单位，默认值是0，如果车辆出场时总停车时长小于x秒出场不进行任何处理
     */
    private Integer enexMinTime   ;

    /**
     * 如果是特殊车场配置出场到入场最小时间值，以秒为单位，默认值是0，如果车辆入场时上次出场时间至当前时间时间差小于x秒入场不进行任何处理
     */
    private Integer exenMinTime   ;

    /**
     * 显示终端类型，1：LED，2：LCD
     */
    private Integer displayTerminal  ;

    /**
     * 控制卡型号 18：方控 19：科发 27：瑞泰科
     */
    private Integer ledcardType  ;

    /**
     * 是否有TTS 0无,1有
     */
    private Integer ttsType  ;

    /**
     * 双摄相机延时等待时长(毫秒),区间100-5000
     */
    private Integer dualcameraTime  ;

    /**
     * 双相机进出时间间隔限制时长（毫秒）
     */
    private Integer dualcameraEnextime;

    /**
     * 红包发放模式，1：自有账户，2：平台账户
     */
    private Integer redpackModel ;

    /**
     * 支持公众号访客预约 0否 1是
     */
    private Integer isVisit ;

    /**
     * 访客车辆是否收费 0否 1是
     */
    private Integer visitIscharge ;

    /**
     * 新能源车辆免收首个2小时停车费（0：否，1：是，默认0）
     */
    private Integer isNewenergyCharge  ;

    /**
     * 入口缴费标识 0不启用 1启用,默认0
     */
    private Integer entryPayFlag   ;

    /**
     * 无牌车扫码校验开关：0：关闭 1：开启 默认0
     */
    private Integer isNocardCheck  ;

    /**
     * 全免车辆重复入场，0：不允许，1：允许
     */
    private Integer freeCarReenter;


    public ParkConfigInfoFind(String parkCode, Integer parkId, Integer dataCollection) {
        this.parkCode = parkCode;
        this.parkId = parkId;
        this.dataCollection = dataCollection;
    }
}
