package com.icetech.cloudcenter.domain.order;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wanggang
 * @create 2022-08-31 14:38
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OrderVO implements Serializable {

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 入场时间
     */
    private Long enterTime;

    /**
     * 车辆类型:1临时车;2月卡车;3特殊车辆;4VIP车辆;5访客车辆;6储值卡车
     */
    private Integer carType;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 入场图片
     */
    private String enterImage;

    /**
     * 订单创建时间
     */
    private Date createTime;

}
