package com.icetech.cloudcenter.domain.enumeration;

import com.icetech.common.utils.StringUtils;
import lombok.Getter;

@Getter
public enum P2cVersionEnum {

    版本1("1.0", 1),
    版本2("1.1", 2),
    版本3("1.2", 3),
    版本4("1.3", 4),
    版本5("1.3.4", 5),
    版本6("1.3.5", 6),
    版本7("1.3.6", 7),
    版本8("1.4", 8),
    版本9("1.5", 9),
    版本10("1.5.1", 10),
    版本11("1.5.2", 11),
    版本12("1.5.3", 12),
    版本13("1.5.4", 13),
    版本14("1.5.5", 14),
    版本15("1.5.6", 15),
    版本16("1.5.7", 16),
    版本17("2.0.0", 17),
    版本18("2.1.0", 18),
    版本19("2.1.1", 19),
    版本20("2.1.2", 20),
    版本21("2.1.3", 21),
    版本22("2.1.4", 22),
    ;

    private String version;
    private int index;

    private P2cVersionEnum(String version, int index){
        this.version = version;
        this.index = index;
    }
    public static int getIndex(String version){
        if (version == null){
            return 0;
        }
        for (P2cVersionEnum p2cVersionEnum : P2cVersionEnum.values()){
            if (p2cVersionEnum.version.equals(version)){
                return p2cVersionEnum.index;
            }
        }
        return 0;
    }

    public static float getNumber(String version) {
        if (StringUtils.isBlank(version)) {
            return 0;
        }
        String[] split = version.split("\\.");
        if (split.length == 1) {
            return 0;
        }
        String newVer = split[0] + ".";
        for (int i = 1; i < split.length; i++) {
            String node = split[i];
            String tempNode = node.length() == 1 ? "0" + node : node;
            newVer = newVer + tempNode;
        }
        return Float.parseFloat(newVer);
    }

}
