package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum P2cDownCmdEnum {

    预缴费("prepay_sync",1),
    月卡("month_card",6),
    远程开关闸("remote_switch",5),
    软触发("soft_trigger",8),
    车场权限下发("channel_rules",901),
    通道权限下发("channel_rules",902),
    黑名单下发("blacklist",10),
    名单数据查询("query_list",11),
    名单数据清空("clear_list",12),
    屏显信息("hint",13),
    入场数据同步("enter_sync",14),
    出场数据同步("exit_sync",15),
    特殊车辆启用("vehicleEnable",19),
    特殊车辆取消("vehicleDisable",20),
    遥控器对应关系("key_value",21),
    访客车辆("visit_card",22),
    自定义语音屏显配置("ledsound_config",23),
    剩余空车位("free_space",24),
    VIP车辆("vip_info",25),
    VIP车辆类型("vip_type",35),
    在场车辆查询("query_inpark",26),
    在场车辆清除("clear_inpark",34),
    计费规则("charge_rule",29),
    LCD自定义语音屏显配置("lcd_config",30),
    LCD屏显语音信息("lcd_hint",31),
    OSS配置下发("oss_config",32),
    储值卡车辆信息("stored_card",36),
    批量下发("biz_batch_down",37),
    升级指令下发("upgrade",38),
    属性配置下发("property_set",42),
    属性获取("property_get",43),

    /**
     * @since protocol_ver >= V1.5.4
     */
    图片抓拍("take_pictures",44),
    计费规则与车牌类型对应关系("charge_platetype_rel",28),
    子订单入场数据同步("enter_sync",46),
    子订单出场数据同步("exit_sync",47),
    区域信息("park_region",33),
    触发脱机记录上报("offline_record",48),
    集团月卡("more_month_card",52),
    车队模式下发("fleet_mode",53),
    ;

    private String cmd;
    private Integer cmdType;

    P2cDownCmdEnum(String cmd, Integer cmdType) {
        this.cmd = cmd;
        this.cmdType = cmdType;
    }

    public static String getCmd(Integer cmdType) {
        for (P2cDownCmdEnum p : P2cDownCmdEnum.values()) {
            if (cmdType.equals(p.getCmdType())) {
                return p.cmd;
            }
        }
        return null;
    }

    public static Integer getCmdType(String cmd) {
        for (P2cDownCmdEnum p : P2cDownCmdEnum.values()) {
            if (cmd.equals(p.getCmd())) {
                return p.cmdType;
            }
        }
        return null;
    }

}
