package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum FullCloudDownCmdEnum {

    名单下发("white_list_operator",6),
    远程开关闸("gpio_out",5),
    设备在线缓存更新("channel_modify",902),
    黑名单下发("blacklist",10),
    白名单数据查询("white_list_select",11),
    名单数据清空("clear_list",12),
    屏显信息下发("serial_data",13),
    语音勿扰模式下发("serial_data",23),
    VIP车辆("free_vip",25),
    图片抓拍("snapshot",44),
    ;

    private String cmd;
    private Integer cmdType;

    FullCloudDownCmdEnum(String cmd, Integer cmdType) {
        this.cmd = cmd;
        this.cmdType = cmdType;
    }

    public static String getCmd(Integer cmdType) {
        for (FullCloudDownCmdEnum p : FullCloudDownCmdEnum.values()) {
            if (cmdType.equals(p.getCmdType())) {
                return p.cmd;
            }
        }
        return null;
    }

    public static Integer getCmdType(String cmd) {
        for (FullCloudDownCmdEnum p : FullCloudDownCmdEnum.values()) {
            if (cmd.equals(p.getCmd())) {
                return p.cmdType;
            }
        }
        return null;
    }

}
