package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

/**
 * 下发业务对应的类型
 *
 */
public enum DownServiceEnum {

	预缴费("notifyPrepay",1),
	缴费查询("queryFee",2),
    无牌车入场("noplateEnter",3),
    无牌车离场("noplateExit",4),
    远程开关闸("remoteSwitch",5),
    月卡("issuedCard",6),
	优惠下发("discountInfo",7),
	黑名单下发("blacklist",10),
	黑白名单下发("blwhlist",10),
	月卡暂停恢复("cardPauseRecover",6),
	实时通道数据("channelData",16),
	请求入场("reqEnter",17),
	语音显示屏内容("showAndSay",18),
	车辆预约("orderEnter",22),
	修改停车费用("modifyFee",27),
	区域信息和计费规则关联关系("parkRegion",28),	// sendinfo用
	//区域信息("parkRegion",33),	// 正式下发用
	计费规则("chargeRule",29),
	通道信息("passageWayConf",902),
	车场配置("parkConfig",901),
	订单修改("modifyCar",34),
	VIP车辆类型("vipCarType",35),
	VIP车辆信息("vipCarInfo",25),
	储值卡车辆信息("storedCard",36),
	LED语音屏显("ledsoundConfig",23),
	LCD语音屏显("lcdsoundConfig",30),
	支付码下发("payCode",39),
	小票领取下发("ticketGot",40),
	接收现金下发("recCash",41),
	批量删除业务数据("batchDelBiz",44),
	批量置为离场业务数据("batchSetExit",45),
	撤销优惠下发("cancelDiscount",49),
	欠费记录删除("delNotPayRecord",50),
	/**
	 * 下发
	 */
	ETC("etcPayStatus",51),

	多车场月卡("moreMonthCard",52),
	;

	@Getter
	private final String serviceName;
	@Getter
	private final Integer serviceType;

	DownServiceEnum(String serviceName, Integer serviceType) {
		this.serviceName = serviceName;
		this.serviceType = serviceType;
	}

	public static String getServiceName(Integer serviceType) {
		for (DownServiceEnum p : DownServiceEnum.values()) {
			if (serviceType.equals(p.getServiceType())) {
				return p.serviceName;
			}
		}
		return null;
	}

	public static Integer getServiceType(String serviceName) {
		for (DownServiceEnum p : DownServiceEnum.values()) {
			if (serviceName.equals(p.getServiceName())) {
				return p.serviceType;
			}
		}
		return null;
	}


}
