package com.icetech.cloudcenter.domain.discount;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 优惠券使用规则配置表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_discount_usercharge")
public class ParkDiscountUsercharge implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 同一车牌可获取几张优惠券 1：一张，2：多张 默认1
     */
    private Integer plateGetCoupons;

    /**
     * 优惠券支持叠加使用 1：支持，2：不支持 默认2
     */
    private Integer supportStackeUsage;

    /**
     * 相同种类的优惠券类型：2：时长券，3：代金券，多个以逗号隔开（优惠券支持叠加使用为1（支持）时有效）
     */
    private String sametypeTogetherUser;

    /**
     * 第三方优惠与商户端券叠加使用 0：不支持，1：支持 默认1
     */
    private Integer thirdpartyStackeUsage;

    /**
     * 一次进出使用优惠券次数 1：一次进出，只能使用一次优惠券，2：一次进出，可多次使用优惠券 默认2（同一车牌可获取几张优惠券为多张2时有效）
     */
    private Integer userMultipleTimes;
    /**
     * 异常离场未使用优惠券退费开关，0：不退费，1：退费
     */
    private Integer exceptionExitRefund;

    /**
     * 添加时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
