package com.icetech.cloudcenter.domain.discount;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 优惠退费记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_order_discount_refund")
public class OrderDiscountRefund implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 关联商户下发的优惠模板ID
     */
    private Integer merchantDisId;

    /**
     * 优惠券名称
     */
    private String discountName;

    /**
     * 关联商户ID
     */
    private Integer merchantId;

    /**
     * 优惠来源（0.本地发放,1:平台发放,2:第三方）默认为0
     */
    private Integer sourceFrom;

    /**
     * 优惠券编号
     */
    private String discountNo;

    /**
     * 入场时间
     */
    private Date enterTime;

    /**
     * 离场时间
     */
    private Date exitTime;

    /**
     * 停车时长
     */
    private Integer parkingTime;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 优惠类型1全免2减免时间3减免金额4折扣
     */
    private Integer type;

    /**
     * 优惠内容
     */
    private String amount;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 单张优惠扣除金额（元）
     */
    private BigDecimal deductMoney;

    /**
     * 退费金额
     */
    private BigDecimal refundMoney;

    /**
     * 发放时间
     */
    private Date sendTime;

    /**
     * 退费时间
     */
    private Date refundTime;

    /**
     * 状态(0未使用1已使用3已过期 默认0
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;


}
