package com.icetech.cloudcenter.domain.constants;

public class RedisConstants {

    /**
     * 消息发送的内容
     */
    public static final String SEND_MSGID_PROFILE = "send_";
    /**
     * 存放消息响应内容，后缀为messageId
     */
    public static final String RESP_MSG_PROFILE = "RESP_MSG_";
    /**
     * 车场车位已满前缀，加车场编号和通道编号
     */
    public static final String PARK_FULL_PROFILE = "PARK_FULL_";
    /**
     * 存放业务下发设备的集合，后跟车场id、业务类型和业务ID
     */
    public static final String BIZ_SEND_DEVICE_PROFILE = "BIZ_SEND_DEVICE_";
    public static final String BIZ_SEND_DEVICE_RECORD = "send:device:";
    /**
     * 出口查询费用失败次数，后跟车场编号、通道编号
     */
    public static final String QUERY_FEE_FAIL_PROFILE = "QUERY_FEE_FAIL:";
    /**
     * 开闸失败次数，后跟车场编号、通道编号
     */
    public static final String SWITCH_FAIL_PROFILE = "SWITCH_FAIL:";

    //======================端云=========================
    /**
     * 出入口相机设备相关信息
     */
    public static final String DEVICE_SN_PROFILE = "p2c:sn:";
    /**
     * 注册成功后，存放设备的信息，后缀为sn
     */
    public static final String P2R_SN_PROFILE = "p2r:sn";
    /**
     * 对讲立柱设备相关信息
     */
    public static final String ITC_SN_PROFILE = "itc:sn:";
    /**
     * 通用设备相关信息，前面跟设备类型，后面是sn
     */
    public static final String COMMON_SN_PROFILE = ":sn:";
    /**
     * 存放设备序列号，如果是双摄相机模式，只存主相机序列号，如果主相机不在线，从相机在线，则存从相机序列号，后缀为车场编号和通道编号
     */
    public static final String SERIAL_NUMBER_PROFILE = "P2C_SERIAL_NUMBER_";
    /**
     * 通道对应的对讲立柱设备序列号，后缀为车场编号和通道编号
     */
    public static final String ITC_CHANNEL_SN_PROFILE = "itc:channel:sn:";
    /**
     * 通道对应的通用设备序列号，前缀是设备类型，后缀为车场编号和通道编号
     */
    public static final String COMMON_CHANNEL_SN_PROFILE = ":channel:sn:";
    /**
     * 车场已连接设备列表，后缀为parkCode
     */
    public static final String PARK_CONNECTED_LIST_PROFILE = "p2c:park:connected:devices:";
    /**
     * 车场已连接对讲立柱设备列表，后缀为parkCode
     */
    public static final String ITC_PARK_CONNECTED_LIST_PROFILE = "itc:park:connected:devices:";
    /**
     * 车场已连接设备列表，通用缓存，前缀是设备类型，后缀为parkCode
     */
    public static final String COMMON_PARK_CONNECTED_LIST_PROFILE = ":park:connected:devices:";
    /**
     * 车场已连接机器人设备列表，后缀为parkCode
     */
    public static final String PARK_ROBOT_CONNECTED_LIST_PROFILE = "p2r:park:connected:devices:";
    /**
     * 入口通道缓存，加车场编号和通道编号
     */
    public static final String CHANNEL_ENTRACE_PROFILE = "P2C_CHANNEL_ENTRACE_";
    /**
     * 出口通道缓存，加车场编号和通道编号
     */
    public static final String CHANNEL_EXIT_PROFILE = "P2C_CHANNEL_EXIT_";
    /**
     * 出口通道的订单缓存，加车场编号和订单编号
     */
    public static final String CHANNEL_ORDER_EXIT_PROFILE = "P2C_CHANNEL_ORDER_EXIT_";
    /**
     * 软触发消息，加触发编号
     */
    public static final String SOFT_TRIGGER_PROFILE = "P2C_SOFT_TRIGGER_";
    public static final String SOFT_IMAGE_PROFILE = "SOFT:IMAGE:PROFILE:";

    /**
     * 当前通道的缓存费用，加车场编号和通道编号
     */
    public static final String CHANNEL_FEE_PROFILE = "P2C_CHANNEL_FEE_";
    /**
     * 确认消息，加消息ID
     */
    public static final String ACK_PROFILE = "P2C_ACK_";
    /**
     * 当前通道的无入场记录车牌
     */
    public static final String CHANNEL_NOENTER_PROFILE = "P2C_CHANNEL_NOENTER_";
    /**
     * 双摄像机主缓存，后跟车场编号 + 通道编号
     */
    public static final String MASTER_CHANNEL_PROFILE = "MASTER_CHANNEL_";
    /**
     * 双摄像机从缓存，后跟车场编号 + 通道编号
     */
    public static final String SLAVE_CHANNEL_PROFILE = "SLAVE_CHANNEL_";
    /**
     * 双摄像机主从缓存，存放车牌信息，后跟车场编号 + 通道编号
     */
    public static final String MASTER_SLAVE_CHANNEL_PROFILE = "MASTER_SLAVE_CHANNEL_";
    /**
     * 通道机器人，存放设备序列号，后跟车场编号 + 通道编号
     */
    public static final String PARK_CHANNEL_ROBOT = "CHANNEL_ROBOT_";

    /**
     * 设备初始化标识，后跟clientname
     */
    public static final String DEVICE_INIT = "P2C:DEVICE:INIT:";
    /**
     * 属性获取，后跟sn
     */
    public static final String PROPERTY_GET_INFO_PROFILE = "p2c:property:get:info:";
    /**
     * 下发属性获取的标识，有值代表下发了，后跟sn
     */
    public static final String PROPERTY_GET_FLAG_PROFILE = "p2c:property:get:flag:";

    //======================端网云=========================

    /**
     * 出口支付信号，加车场ID和通道ID
     */
    public static final String PNC_EXIT_PAY_CHANNEL_PROFILE  = "PNC_EXIT_CHANNEL_PAY_";
    /**
     * 出口支付信号，加车场ID和订单号
     */
    public static final String PNC_EXIT_PAY_ORDER_PROFILE  = "PNC_EXIT_ORDER_PAY_";
    /**
     * 车场在线通道号，加车场编号
     */
    public static final String PNC_ONLINE_CHANNEL_PROFILE  = "PNC_ONLINE_CHANNEL_";
    /**
     * 文件ID缓存，加车场编号和文件ID，值为文件地址
     */
    public static final String PNC_FILEID_PROFILE  = "PNC_FILEID_PROFILE_";
    /**
     * 获取需要下发第三方的所有车场编号(支付码下发,小票领取成功下发,现金收费下发)<br>
     * 存储格式:多个车场编号以逗号隔开
     */
    public static final String PNC_THIRD_PARTY_DOWN_PARKS  = "pnc:thirdpartydown:parks";
    /**
     * pnc ws心跳
     */
    public static final String PNC_HEART_PROFILE = "PNC_HEART_PROFILE_";

    //======================批量下发任务=========================

    /**
     * 批量下发任务列表，后跟主任务ID
     */
    public static final String BATCH_DOWN_TASK_LIST  = "batchdown:task:";

    /**
     * 批量下发子任务HASH，后跟子任务ID
     */
    public static final String BATCH_DOWN_SUBTASK_HASH  = "batchdown:task:sub:";
    /**
     * 批量下发任务的业务数据id列表，后跟子任务ID
     */
    public static final String BATCH_DOWN_DATA_LIST  = "batchdown:task:data:";
    /**
     * 批量下发的消息ID，后跟messageId
     */
    public static final String BATCH_DOWN_MSGID  = "batchdown:msgid:";
    /**
     * 批量下发任务打开状态，后跟车场ID+业务类型
     */
    public static final String BATCH_DOWN_OPEN_FLAG  = "batchdown:open:";

    //======================升级指令下发任务=========================

    /**
     * 升级指令下发任务详情，后跟任务ID
     */
    public static final String UPGRADE_TASK_HASH  = "upgrade:task:";
    /**
     * 升级任务id和消息id的对应，后跟消息id
     */
    public static final String UPGRADE_TASK_MESSAGE  = "upgrade:task:message:";

    /**
     * 萤石云Token
     */
    public static final String PREFIX_YSY_TOKEN = "ysy:token:";
    /**
     * MQTT心跳去重KEY
     */
    public static final String MQTT_HEARTBEAT = "mqtt:heartbeat:";

    /**
     * 端云心跳时间
     */
    public static final String P2C_HEARTBEAT_TIME = "p2c:heartbeat:time";
    /**
     * 监控相机心跳时间
     */
    public static final String COMMON_HEARTBEAT_TIME = ":heartbeat:time";
    /**
     * 端云机器人心跳时间
     */
    public static final String P2R_HEARTBEAT_TIME = "p2r:heartbeat:time";
    /**
     * 端云立柱心跳时间
     */
    public static final String ITC_HEARTBEAT_TIME = "itc:heartbeat:time";
    /**
     * 端云追缴相机心跳时间
     */
    public static final String MOR_HEARTBEAT_TIME = "mor:heartbeat:time";
    /**
     * 端网云协议类型
     */
    public static final String PNC_PROTOCOL = "pnc:protocol";
    /**
     * 端网云心跳时间
     */
    public static final String PNC_HEARTBEAT_TIME = "pnc:heartbeat:time";
    public static final String PNC_HEARTBEAT_CHARGE_TIME_PREFIX = "pnc:heartbeat:charge:";
    /**
     * 端网云空车位
     */
    public static final String PNC_FREESPACE = "pnc:freespace";
    /**
     * 端网云版本号
     */
    public static final String PNC_VERSION = "pnc:version";
    /**
     * 离线检测任务的上次执行时间
     */
    public static final String HEARTBEAT_TASK_TIME = "heartbeat:task:time";
    /**
     * messageId和triggerNo的对应关系
     */
    public static final String MESSAGE_ID_TRIGGER_NO = "messageId:triggerNo:";
    /**
     * 脱机计费标识，后跟订单编号
     */
    public static final String OFF_LINE_FEE_PROFILE = "offline:fee:";
    /**
     * 场中场进记录缓存
     */
    public static final String ENTER_RECORDS_PROFILE = "enter:records:";
    /**
     * 场中场出记录缓存
     */
    public static final String EXIT_RECORDS_PROFILE = "exit:records:";
    /**
     *  支付锁前缀，后跟车场编号+订单号，值为union_id
     */
    public static final String PAY_LOCK_KEY = "PAY_LOCK_";
    /**
     *  支付锁前缀，后跟union_id，值为最近交易流水
     */
    public static final String PAY_USER_KEY = "PAY_USER_";


    /**
     *  通道费用锁，后跟ParkCode和通道编号
     */
    public static final String CHANNEL_FEE_LOCK_KEY = "channelFee:";
    /**
     *  支付渠道锁，后跟orderNum
     */
    public static final String PAY_CHANNEL_LOCK_KEY = "lock:pay:channel:";
    /**
     *  支付成功后锁，后跟orderNum
     */
    public static final String PAY_AFTER_LOCK_KEY = "lock:pay:after:";
    /**
     * etc支付中的锁
     */
    public static final String ETC_PAY_LOCK_KEY = "lock:etc:pay:";
    /**
     * 拉费etc锁
     */
//    public static final String ETC_FEE_LOCK = "lock:etc:fee:";
    /**
     * 软触发图片，后跟通道编号
     */
    public static final String SOFT_TRIGGER_IMAGE_KEY = "softTrigger:image:";
    /**
     * 端云无抓拍接口功能，小key为sn, value为上次抓拍时间
     */
    public static final String NO_TAKE_PICTURE_FUNC_KEY = "p2c:no:takepicture:func";

    /**
     * 查询费用的过程锁
     */
    public static final  String QUERY_FEE_LOCK = "lock:queryFee:";
}
