package com.icetech.cloudcenter.domain.constants;

import com.icetech.common.utils.StringUtils;

public class DataCommonConstants {

    /**
     * 忽略显示的参数
     */
    public static final String[] EXCLUDE_PARAMS = {"base64Str"};
    public static final String NO_PLATE_FLAG = "临";
    public static final String WEI_SHI_BIE = "未识别";
    public static final String NO_PLATE = "无牌车";

    public static boolean isNoPlate(String plateNum) {
        if (StringUtils.isBlank(plateNum)) {
            return false;
        }
        return WEI_SHI_BIE.equals(plateNum) || NO_PLATE.equals(plateNum);
    }
}
