package com.icetech.cloudcenter.domain.constants;

import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;

/**
 * 批量下发
 * @author fangct
 */
public class BatchSendConstants {
    //101：高级配置，102：通道信息 ，103：计费规则，104：屏显配置，105:高级配置+通道信息
    public static final int PARK_CONFIG = 101;
    public static final int CHANNEL_CONFIG = 102;
    public static final int CHARGE_CONFIG = 103;
    public static final int HINT_CONFIG = 104;
    public static final int PARK_CHANNEL_CONFIG = 105;

    //201：月卡车、202：黑名单、203：VIP车辆、204：优惠、205：访客车辆
    public static final int MC_BIZ = 201;
    public static final int BL_BIZ = 202;
    public static final int VIP_BIZ = 203;
    public static final int DISCOUNT_BIZ = 204;
    public static final int VISIT_BIZ = 205;

    public static Integer convert2BatchBizOpenType(int dataType){
        switch (dataType){
            case MC_BIZ:
                return P2cDownCmdEnum.月卡.getCmdType();
            case BL_BIZ:
                return P2cDownCmdEnum.黑名单下发.getCmdType();
            case VIP_BIZ:
                return P2cDownCmdEnum.VIP车辆.getCmdType();
            default:
                return null;
        }
    }
}
