package com.icetech.cloudcenter.domain.charge.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 24小时计费
 *
 * @author fangct
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class S24HoursChargeCfgDTO implements Serializable {
    /**
     * 免费时长（分钟）
     */
    public Integer sFreetime;
    /**
     * 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0
     */
    public Integer sDaynightmaxfeeusing;
    /**
     * 单天最高收费金额元
     */
    public Float sDaynightmaxfee;
    /**
     * 最高收费类型  1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 4=单次最高收费
     */
    public Integer sMaxfeetype;
    /**
     * 单天最高收费金额元_大型车
     */
    public Float sDaynightmaxfee_big;
    /**
     * 时间分割方式
     */
    public Integer sDivisionTime;
    /**
     * 是否启用跨天后收费 1是 2否 默认为2
     */
    public Integer sIsOverTimeSet;
    /**
     * 跨天后每间隔多长分钟
     */
    public Integer sFeeSpanTimeStep;
    /**
     * 跨天后单位费用
     */
    public Float sFeeSpanRateStep;
    /**
     * 跨天后单位费用_大型车
     */
    public Float sFeeSpanRateStep_big;
    /**
     * 计费费率信息
     */
    public List<S24HoursRateCfgDTO> sRateCfg;

}
