package com.icetech.cloudcenter.domain.charge.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 通用自然天计费
 *
 * @author fangct
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class NaturalChargeCfgDTO implements Serializable {
    /**
     * 免费时长（分钟）
     */
    public Integer sFreetime;
    /**
     * 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0
     */
    public Integer sDaynightmaxfeeusing;
    /**
     * 最高收费类型  1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 4=单次最高收费
     */
    public Integer sMaxfeetype;
    /**
     * 单天最高收费金额元
     */
    public Float sDaynightmaxfee;
    /**
     * 单天最高收费金额元_大型车
     */
    public Float sDaynightmaxfee_big;
    /**
     * 工作日计费方式 1：按次计费 2：按时计费
     */
    public Integer sBillmethod;
    /**
     * 非工作日计费方式 1：按次计费 2：按时计费
     */
    public Integer sNoworkBillmethod;
    /**
     * 是否区分工作日非工作日计费 1是 2否 默认为2
     */
    public Integer sIsspecialdaycharge;
    /**
     * 工作日按次计费
     */
    public OnceChargeCfgDTO sWork_OnceCharge;
    /**
     * 工作日按时计费
     */
    public DyrationChargeCfgDTO sWork_DyrationCharge;
    /**
     * 非工作日按次计费
     */
    public OnceChargeCfgDTO sNoWork_OnceCharge;
    /**
     * 非工作日按时计费
     */
    public DyrationChargeCfgDTO sNoWork_DyrationCharge;

}
