package com.icetech.cloudcenter.domain.charge.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 按时计费
 *
 * @author fangct
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class DyrationChargeCfgDTO implements Serializable {
    /**
     * 超出多少分钟配置是否起作用 （1:是，2:否，默认2）
     */
    public Integer sIsOverTimeSet;
    /**
     * 超过分钟数
     */
    public Integer sOverTime;
    /**
     * 单位时间分钟
     */
    public Integer sFeeSpanTime;
    /**
     * 单位金额元
     */
    public Float sFeeSpanRate;
    /**
     * 单位金额元_大型车
     */
    public Float sFeeSpanRate_big;
    /**
     * 计费阶梯信息
     */
    public List<StepChargeCfgDTO> sStepChargeCfg;

}
