package com.icetech.cloudcenter.api.third;

import com.icetech.third.domain.entity.third.ThirdParkRef;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 三方车场关联信息表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-16
 */
public interface ThirdParkRefService extends IBaseService<ThirdParkRef> {

    /**
     * Description: 根据ID查询 三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ThirdParkRef
     */
    ThirdParkRef getThirdParkRefById (Long id);

    /**
     * Description: 新增  三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addThirdParkRef (ThirdParkRef entity);

    /**
     * Description: 修改 三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyThirdParkRef (ThirdParkRef entity);

    /**
     * Description: 删除  三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeThirdParkRefById (Long id);
}
