package com.icetech.cloudcenter.api.third;

import com.icetech.third.domain.entity.third.ThirdParam;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 三方参数表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-09-15
 */
public interface ThirdParamService extends IBaseService<ThirdParam> {

    /**
     * Description: 根据ID查询 三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param id 对象id
     * @return ThirdParam
     */
    ThirdParam getThirdParamById (Long id);

    /**
     * Description: 新增  三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addThirdParam (ThirdParam entity);

    /**
     * Description: 修改 三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyThirdParam (ThirdParam entity);

    /**
     * Description: 删除  三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeThirdParamById (Long id);
}
