package com.icetech.cloudcenter.api.third;


import com.icetech.third.domain.entity.third.*;
import com.icetech.park.domain.entity.park.ThirdParkMessage;
import com.icetech.cloudcenter.domain.response.ThirdParkInfoResponse;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * 第三方信息DAO
 * @author fangct
 */
public interface ThirdInfoService{

    /**
     * 通过车场id和三方id获取该车场三方配置信息
     *
     * @param parkId
     * @param thirdId
     * @return
     */
    ObjectResponse<ThirdParam> getParkThirdParam(Long parkId, Long thirdId);

    /**
     * 通过三方id获取该三方的配置属性
     *
     * @param thirdId
     * @return
     */
    ObjectResponse<List<ThirdAttribute>> getThirdAttribute(Long thirdId);

    /**
     * 通过车场id获取三方广告车场信息
     *
     * @param parkId
     * @return
     */
    ThirdParkMessage getThirdParkMessageBy(Long parkId);

    List<ThirdParkInfoResponse> selectByPid(String pid);

    /**
     * 查询第三方配置信息
     * @param pid
     * @return
     */
    ObjectResponse<ThirdInfo> selectThirdInfo(String pid);

    ThirdInfo selectById(ThirdInfo para);

    ThirdInfo selectParkThirdConf(Long parkId,String pId);
    /**
     * 检查三方对接权限内容
     * @param parkId
     * @param serviceName
     * @return
     */
    Integer checkOpenPushAccount(Long parkId, String serviceName);

    /**
     *  获取三方计费链接
     * @param parkId
     * @return
     */
    ThirdInfo getThirdFeeUrl(Long parkId);

    /**
     * 获取三方二维码地址
     * @param parkId
     * @return
     */
    ThirdInfo getThirdQrUrl(Long parkId);

    /**
     * 获取广告第三方
     * @param parkId
     * @return
     */
    ThirdInfo getThirdAdvice(Long parkId);

    /**
     * 修改三方额外配置参数通过id
     *
     * @param params
     * @param id
     * @return
     */
    Boolean updateParams(String params, Integer id);

    /**
     * 三方推送添加扩展记录
     *
     * @param pushExtend
     * @return
     */
    Boolean addPushExtend(PushExtend pushExtend);

    /**
     * 通过id删除扩展记录
     *
     * @param id
     * @return
     */
    Boolean deletePushExtendById(Long id);

    /**
     * 通过车场id和车牌号获取扩展记录
     *
     * @param parkId
     * @param plateNum
     * @param enterTime
     * @return
     */
    PushExtend getPushExtend(Long parkId, String plateNum, Long enterTime);

    /**
     * 新增 ThirdInfo
     * @param thirdInfo 参数
     * @return
     */
    Integer addThirdInfo(ThirdInfo thirdInfo);


    /**
     * 添加三方车场属性配置
     *
     * @param params
     * @return
     */
    ObjectResponse<ThirdParam> addParkThirdParam(ThirdParam params);

    /**
     * 通过id获取车场三方配置信息
     *
     * @param id
     * @return
     */
    ObjectResponse<ThirdParam> getPakThirdParamBy(Long id);


    /**
     * 修改车场三方配置属性信息
     *
     * @param thirdParam
     * @return
     */
    ObjectResponse<ThirdParam> updateParkThirdParams(ThirdParam thirdParam);

    /**
     * 通过三方获取三方管理车场信息
     *
     * @param thirdId
     * @param pageNo
     * @param pageSize
     * @param parkId
     * @return
     */
    ObjectResponse<Page<ThirdParam>> getThirdParkPage(Long thirdId, Integer pageNo, Integer pageSize, Long parkId);


    /**
     * 通过三方id获取三方关联的额外参数
     *
     * @param thirdId
     * @return
     */
    ObjectResponse<List<ThirdParam>> getThirdParamsByThirdId(Long thirdId);

    /**
     * 初始化泊斯特车场信息
     *
     * @param thirdBstPark
     * @return
     */
    ObjectResponse<Void> addThirdBstPark(ThirdBstPark thirdBstPark);

    /**
     * 批量保存泊斯特车场广告位
     *
     * @param bstAdSpaces
     * @return
     */
    ObjectResponse<Void> batchSaveBstParkSpace(List<BstAdSpace> bstAdSpaces);


    /**
     * 获取泊斯特广告位信息
     *
     * @param parkCode 车场编码
     * @param deviceType 设备类型 0：公众号；1：小程序； 2：APP；3：缴费机 4：补交机 ；5;电视机；6：支付宝；9;通用设备
     * @param triggerEvent 触发事件。 0:车牌查询页（输入车牌页面）；1:支付完成页（支付完毕）；2:入场消息推送页；3:出场消息推送页；4:优惠活动广告页； 5:首页广告；6:支付确认（付款前）;7：启动页；8：支付完成通知；9:弹出式广告页面;10:口令广告;15：一般页面广告;16:公众号菜单栏;17:线下二维码;32:其他页
     * @return
     */
    ObjectResponse<BstAdSpace> getBstAdSpace(String parkCode, Integer deviceType, Integer triggerEvent);
    /**
     * 根据同程编码查询第三方
     * @param parkNo
     * @return
     */
    ObjectResponse<ThirdInfo> selectThirdByTongchengPark(String parkNo);
    /**
     * 根据同程编码查询第三方车场
     * @param parkNo
     * @return
     */
    ObjectResponse<ThirdTongchengPark> selectTongchengPark(String parkNo);

    /**
     * 根据平台编码查询车场
     * @param parkCode
     * @return
     */
    ObjectResponse<ThirdTongchengPark> selectTongchengParkCode(String parkCode);

    /**
     * 根据同程编码查询
     * @param parkNo
     * @param chNo
     * @return
     */
    ObjectResponse<ThirdTongchengParkChannel> selectTongchengParkChannel(String parkNo,String chNo);

    /**
     * 根据平台编码查询
     * @param parkCode
     * @param channelCode
     * @return
     */
    ObjectResponse<ThirdTongchengParkChannel> selectTongchengParkCodeChannel(String parkCode,String channelCode);

    /**
     * 海大穿行配置第三方配置
     * @param parkId
     * @return
     */
    ThirdInfo selectHaiDaChuanXIng(Long parkId);

    /**
     * 海大集团月卡配置
     * @param parkId
     * @return
     */
    ThirdInfo selectHaiDaJituan(Long parkId);

    /**
     * 获取三方信息,通过pid和三方车场id
     * @param pid
     * @param parkId
     * @return
     */
    ObjectResponse<ThirdInfo> getThirdInfoBy(String pid, Long parkId);

}
