package com.icetech.cloudcenter.api.report;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.report.domain.entity.ParkReportStatics;
import com.icetech.report.domain.vo.ElectronAmountPayNumVo;
import com.icetech.report.domain.vo.ParkChannelReportVo;
import com.icetech.report.domain.vo.ParkChannelStatisticsVo;
import com.icetech.report.domain.vo.ParkPayReportVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场统计营分析报表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-17
 */
public interface ParkReportStaticsService extends IBaseService<ParkReportStatics> {

    /**
     * Description: 根据ID查询 车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param id 对象id
     * @return ParkReportStatics
     */
    ParkReportStatics getParkReportStaticsById(Long id);

    /**
     * Description: 新增  车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkReportStatics(ParkReportStatics entity);

    /**
     * Description: 修改 车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkReportStatics(ParkReportStatics entity);

    /**
     * Description: 删除  车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkReportStaticsById(Long id);

    /**
     * 获取动销车场和出口道口数
     *
     * @param reportDate
     * @return
     */
    ParkChannelStatisticsVo getParkChannelsStatistics(Long reportDate);

    /**
     * 获取总的支付金额
     *
     * @param reportDate
     * @return
     */
    BigDecimal getTotalPayAmount(Long reportDate);

    /**
     * 获取电子支付金额和电子支付笔数
     *
     * @param reportDate
     * @return
     */
    ElectronAmountPayNumVo getElectronAmountPayNum(Long reportDate);

    /**
     * 获取电子支付金额按天展示
     *
     * @param month
     * @return
     */
    List<ParkPayReportVo> getParkPayMonth(Integer month);

    /**
     * 获取电子支付金额按月展示
     *
     * @param year
     * @return
     */
    List<ParkPayReportVo> getParkPayYear(Integer year);

    /**
     * 获取动销车场和通道列表(年)
     *
     * @param startTime
     * @param endTime
     * @return
     */
    List<ParkChannelReportVo> getParkNumsYearList(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 获取动销车场和通道列表(月)
     *
     * @param startTime
     * @param endTime
     * @return
     */
    List<ParkChannelReportVo> getParkNumsMonthList(@Param("startTime") String startTime, @Param("endTime") String endTime);
}
