package com.icetech.cloudcenter.api.report;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.report.domain.entity.ParkOtherIncome;
import com.icetech.report.domain.vo.IncomeVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场其他收入 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-01
 */
public interface ParkOtherIncomeService extends IBaseService<ParkOtherIncome> {

    /**
     * Description: 根据ID查询 车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param id 对象id
     * @return ParkOtherIncome
     */
    ParkOtherIncome getParkOtherIncomeById(Long id);

    /**
     * Description: 新增  车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkOtherIncome(ParkOtherIncome entity);

    /**
     * Description: 修改 车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkOtherIncome(ParkOtherIncome entity);

    /**
     * Description: 删除  车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkOtherIncomeById(Long id);

    /**
     * 获取年其他收入
     *
     * @param year
     * @return
     */
    BigDecimal getYearOtherAmount(Integer year);

    /**
     * 获取年其他收入按月展示
     *
     * @param year
     * @return
     */
    List<IncomeVo> getOtherYear(Integer year);


    /**
     * 获取月其他收入按天展示
     *
     * @param month
     * @return
     */
    List<IncomeVo> getOtherAmountMonth(Integer month);
}
