package com.icetech.cloudcenter.api.report;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.report.domain.entity.ParkAdvertIncome;
import com.icetech.report.domain.vo.AdvertReportVo;
import com.icetech.report.domain.vo.AdvertVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场广告收益表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-18
 */
public interface ParkAdvertIncomeService extends IBaseService<ParkAdvertIncome> {

    /**
     * Description: 根据ID查询 车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param id 对象id
     * @return ParkAdvertIncome
     */
    ParkAdvertIncome getParkAdvertIncomeById(Long id);

    /**
     * Description: 新增  车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkAdvertIncome(ParkAdvertIncome entity);

    /**
     * Description: 修改 车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkAdvertIncome(ParkAdvertIncome entity);

    /**
     * Description: 删除  车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkAdvertIncomeById(Long id);

    /**
     * 获取指定日期广告收益
     *
     * @param reportDate 日期
     * @return
     */
    List<AdvertVo> getAdvertIncome(Long reportDate);

    /**
     * 获取年的广告收益统计
     *
     * @param year
     * @return
     */
    List<AdvertReportVo> getReportYear(Integer year);

    /**
     * 获取月的广告收益
     * @param month
     * @return
     */
    List<AdvertReportVo> getReportMonth(Integer month);

    /**
     * 获取全年收益
     *
     * @param year 年份
     * @return
     */
    BigDecimal getSumAmount(int year);
}
