package com.icetech.cloudcenter.api.parkvip;

import com.icetech.cloudcenter.domain.parkvip.ParkAuthUserBaseDto;
import com.icetech.cloudcenter.domain.parkvip.ParkVipUser;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 车场会员授权用户 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface IParkVipUserService {
    /**
     * 账号授权操作
     * @param parkCode 车场编号
     * @param accounts 授权账户
     * @param phoneNum 联系电话
     * @return
     */
    ObjectResponse<Void> authUserVip(String parkCode, List<String> accounts,String phoneNum);

    /**
     * 获取授权用户信息
     * @param parkCode
     * @return
     */
    ObjectResponse<ParkAuthUserBaseDto> getAuthUser(String parkCode);

}
