package com.icetech.cloudcenter.api.park;

import com.icetech.user.domain.entity.user.SaasUserPark;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 用户与车场关联表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-08-26
 */
public interface SaasUserParkService extends IBaseService<SaasUserPark> {


    /**
     * 删除saas用户和车厂关联关系
     *
     * @param ids
     * @return
     */
    ObjectResponse<Void> deleteByParkIds(List<Integer> ids);

    /**
     * 通过车场id获取sass用户对应的车场关系
     *
     * @param parkId
     * @return
     */
    List<SaasUserPark> listByParkId(Long parkId);
    
    /**
     * Description: 通过机构id 集合查询
     * Version1.0 2023-11-29 by wgy 创建
     * 
     * @param institutionIds    机构 id
     * @return java.util.List<com.icetech.user.domain.entity.user.SaasUserPark>       
     */
    List<SaasUserPark> getSaasUserParkByInstitutionIds(List<Integer> institutionIds);
}
