package com.icetech.cloudcenter.api.park;

import com.icetech.basics.domain.request.ParkVisitBatchDeleteParam;
import com.icetech.cloudcenter.domain.response.ParkVisitDto;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.dto.VisitQueryDto;
import com.icetech.park.domain.entity.park.ParkVisit;

import java.util.Date;
import java.util.List;

/**
 * 车场服务接口
 * @author fangct
 */
public interface ParkVisitService {
    /**
     * 查詢预约车
     * @param vId
     * @return
     */
    ObjectResponse<ParkVisitDto> selectVisitByid(Long vId);
    /**
     * 验证访客车辆
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<ParkVisit> checkVisitPlate(Long parkId, String plateNum);
    /**
     * 分页查询预约访客
     * @param parkCode
     * @param userId
     * @param pageNo
     * @param pageSize
     * @return
     */
    ObjectResponse<List<ParkVisitDto>> getMpVisit(String parkCode, Integer userId, Integer pageNo, Integer pageSize);


    ObjectResponse<com.icetech.common.domain.Page<ParkVisitDto>> getMpVisitV2(Long accountId, VisitQueryDto visitVo);
    /**
     * 分页查询预约访客总条数
     * @param parkCode
     * @param userId
     * @return
     */
    ObjectResponse countMpVisit(String parkCode, Integer userId);
    /**
     * 查询指定预约
     * @param visitNum
     * @return
     */
    ObjectResponse<ParkVisitDto> getMpVisitByVisitNum(String visitNum);
    /**
     * 增加访客预约
     * @param parkVisit
     * @return
     */
    ObjectResponse<Void> addMpVisit(ParkVisit parkVisit);
    ObjectResponse addMpVisitByOhter(ParkVisit parkVisit);
    ObjectResponse updateMpVisitByOhter(ParkVisit parkVisit);

    /**
     * 获取已经存在的预约数据
     * @param parkId
     * @param from
     * @param startTime
     * @return
     */
    ObjectResponse<List<String>> findVisitNumOtherByDate(Long parkId,Integer from,String startTime,Integer checkStatus);

    /**
     * Description: 批量删除访客记录
     * Version1.0 2024-01-30 by wgy 创建
     *
     * @param parkIds                       用户车场 id
     * @param parkVisitBatchDeleteParam     参数
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Void>
     */
    ObjectResponse<Void> deleteVisitBatch(List<Long> parkIds, ParkVisitBatchDeleteParam parkVisitBatchDeleteParam);

    /**
     * 海大定制添加访客车辆
     *
     * @param parkVisits
     * param userId
     * @return
     */
    ObjectResponse addMpVisits(List<ParkVisit> parkVisits, Integer userId);

    /**
     * 海大分页
     *
     * @param parkIds
     * @param plateNum
     * @param pageNo
     * @param pageSize
     * @param visitStatus
     * @param startTime
     * @param endTime
     * @return
     */
    Page<ParkVisit> haiDaPage(List<Integer> parkIds, String plateNum, Integer pageNo, Integer pageSize, List<Integer> visitStatus, String startTime, String endTime);


    Page<ParkVisit> guoKongPage(Integer mpUserId, String plateNum, Integer pageNo, Integer pageSize, List<Integer> visitStatus, String startTime, String endTime);

    /**
     * 获取海大添加次数
     *
     * @param parkIds
     * @return
     */
    Integer getTotalNum(List<Integer> parkIds);

    /**
     * 石家庄访客
     *
     * @param visit
     * @return
     */
    ObjectResponse<String> addShiJiaZhuangVisit(ParkVisit visit);

    /**
     * 获取访客车辆
     *
     * @param parkId
     * @param date
     * @return
     */
    ObjectResponse<List<ParkVisit>> getParkVisitList(Long parkId, Date date);

    /**
     * 国控添加访客优惠
     *
     * @param visit
     * @return
     */
    ObjectResponse<Void> addGuoKongParkVisit(ParkVisit visit);


    /**
     * 获取访客车信息
     *
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<ParkVisit> getGuoKongParkVisitByParkIdAndPlateNum(Integer parkId, String plateNum);

    /**
     * 删除访客
     *
     * @param id
     * @param loginName
     * @return
     */
    ObjectResponse<Void> deleteVisit(Long id, String loginName);
}
