package com.icetech.cloudcenter.api.park;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.icetech.basics.domain.entity.AreaCity;
import com.icetech.basics.domain.entity.AreaDistrict;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeNaturalday;
import com.icetech.basics.domain.entity.park.*;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceMsgInfo;
import com.icetech.cloudcenter.domain.park.query.ParkVisitInfo;
import com.icetech.park.domain.entity.park.InitBstPark;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkMessage;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.cloudcenter.domain.park.ChangPingParkUser;
import com.icetech.cloudcenter.domain.park.ParkAllInfo;
import com.icetech.cloudcenter.domain.park.ParkInfo;
import com.icetech.cloudcenter.domain.park.ParkListGroup;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceParam;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkQuery;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.response.AisleDto;
import com.icetech.basics.domain.dto.DictionaryItemDto;
import com.icetech.cloudcenter.domain.response.OrganizationTreeDto;
import com.icetech.cloudcenter.domain.response.ParkAreaDetailDto;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.cloudcenter.domain.response.ParkPlotsDto;
import com.icetech.cloudcenter.domain.response.PassWayDto;
import com.icetech.cloudcenter.domain.vo.ParkChargeRuleVO;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * 车场服务接口
 * @author fangct
 */
public interface ParkService {



    /**
     * 获取所有车场id车场名称以及所在城市
     * @return
     */
    List<ParkMessage> findAllBy();

    /**
     * 获取所有车场
     * @return
     */
    List<Park> fidAll();


    /**
     * 添加修改用户首页默认通道
     * @param aisleCode
     * @param userId
     * @return
     */
    ObjectResponse modifyUserDefultAisle(String aisleCode,Integer userId);
    /**
     * 获取用户首页默认通道
     * @return
     */
    ObjectResponse<List<PassWayDto>> getUserDefultAisle(Integer userId);
    /**
     * 查询车场区域列表
     * @param parkId 车场ID
     * @return
     */
    ObjectResponse<List<ParkRegion>> selectRegionById(Long parkId);
    /**
     * 查询车场区域
     * @param id
     * @return
     */
    ObjectResponse<ParkRegion> getParkRegionById(Long id);
    /**
     * 根据语音对讲设备id获取通道信息
     * @param vid
     * @return
     */
    ObjectResponse<PassWayDto> findWayDetailByvid(String vid);
    /**
     * 根据车场名称车场模糊查询
     * @param name
     * @return
     */
    ObjectResponse<List<ParkDto>> selectParkByname(String name);
    /**
     * 获取通道和监控设备信息
     * @return
     */
    ObjectResponse<List<PassWayDto>> getPassageWayInfo(int id,int type,Integer userId);
    /**
     * 获取当前用户组织机构树
     * @return
     */
    ObjectResponse<List<OrganizationTreeDto>> selectOrganizationTree(Integer userId);

    /**
     * Description: 查询所有组织机构
     * Version1.0 2023-07-03 by wgy 创建
     *
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.cloudcenter.domain.response.OrganizationTreeDto>>
     */
    ObjectResponse<List<OrganizationTreeDto>> selectAllOrganiz();

    ObjectResponse<Park> findByParkId(Long parkId);

    ObjectResponse<Park> findByParkCode(String parkCode);

    ObjectResponse<Long> getFreeByParkCode(String parkCode);

    /**
     * Description: 通过车场 id 查询车场信息
     * Version1.0 2023-07-07 by wgy 创建
     *
     * @param parkIds    车场 id 集合
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.basics.domain.entity.park.BasePark>>
     */
    ObjectResponse<List<BasePark>> getBaseParkList(Collection<Long> parkIds);

    /**
     * Description: 通过名称搜索车场数据
     * Version1.0 2023-07-25 by wgy 创建
     *
     * @param name      车场名称
     * @param parkIds   车场 id
     * @param limit     限制条数
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.basics.domain.entity.park.BasePark>>
     */
    ObjectResponse<List<BasePark>> getBaseParkName(String name, Collection<Long> parkIds, Integer limit);

    /**
     * 上报车场信息
     * @return
     */
    ObjectResponse<Boolean> reportParkInfo();

    /**
     * 统计停车场总数和车位个数
     * @param parkIdList
     * @return
     */
    ObjectResponse<ParkPlotsDto> countParkPlots(String parkIdList);

    /**
     * 按区域省份统计停车场总数和车位个数
     * @param parkIdList
     * @return
     */
    ObjectResponse<List<ParkAreaDetailDto>> countParkPlotsByArea(String parkIdList);

    /**
     * 获取当前用户管理的所有车场
     * @param userId
     * @return
     */
    ObjectResponse<List<ParkDto>>  getParkList(Integer userId);

    /**
     * 获取用户下的车场信息 指定parkId
     * @param userId 用户ID
     * @param parkIds 用户车场权限列表
     * @param parkNameKey 车场名称查询关键字
     * @return
     */
    ObjectResponse<List<ParkDto>>  getParkList(Integer userId, List<Long> parkIds, String parkNameKey);

    /**
     * 模糊搜索限制100条车场信息
     * @param userId
     * @param key
     * @return
     */
    ObjectResponse<List<ParkDto>>  getParkListLimit(Integer userId,String key);

    /**
     * 根据用户ID查询权限范围下的车场列表
     * @param userId 用户ID
     * @return 车场列表
     */
    List<Long> getParkListByUserId(Integer userId);
    List<Long> getParkListByUserId(Integer userId, String parkCode, String parkName);

    /**
     * 获取某个车场下的出入口列表
     * @param parkCode
     * @param type
     * @return
     */
    ObjectResponse<List<AisleDto>> getAisleList(String parkCode, Integer type);
    /**
     * 获取某个车场X类型的通道列表
     * @param parkId
     * @param type
     * @return
     */
    ObjectResponse<List<ParkInoutdevice>> getChannelByType(Long parkId, Integer type);

    /**
     * 查询车场所有通道
     * @param parkId
     * @return
     */
    ObjectResponse<List<ParkInoutdevice>> getAllChannel(Long parkId);
    /**
     * 通过相机序列号获取设备通道信息
     * @param parkId
     * @param serialNumber
     * @return
     */
    ObjectResponse<ParkInoutdevice> getChannelInfo(Long parkId, String serialNumber);

    /**
     * 获取车场配置
     * @param parkId
     * @return
     */
    ObjectResponse<ParkConfig> getParkConfig(Long parkId);
    ObjectResponse<ParkConfig> getParkConfig(String parkCode);

    /**
     * 批量获取车场配置
     * @param parkIds
     * @return Map<parkId, ParkConfig>
     */
    ObjectResponse<Map<Long, ParkConfig>> getParkConfigs(Collection<Long> parkIds);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    ObjectResponse<ParkInoutdevice> getInoutDeviceById(Long id);
    List<ParkInoutdevice> getInoutDeviceByIds(List<Long> idList);

    ObjectResponse<ParkInoutdevice> getInoutDeviceByCode(String channelCode);

    /**
     * 获取车场的免费停车时长
     * @param parkId
     * @return
     */
    ObjectResponse<Integer> getFreeTime(Long parkId);

    ParkChargeRuleVO getFreeTimeLocal(Long parkId, Long regionId);

    /**
     * 获取最小免费时长
     * @param parkId 车场ID
     * @return 最小免费时长
     */
    ObjectResponse<ParkChargeRuleVO> getMinFreeTime(Long parkId);

    /**
     * 获取出入口编号
     * @param parkId
     * @param channelCode
     * @return
     */
    ObjectResponse<ParkInoutdevice> getInOutDeviceByCode(Long parkId, String channelCode);

    /**
     * 保存开关闸记录表
     * @return
     */
    ObjectResponse<Integer> saveOpeningRecord(OpeningDtoRequest request);

    /**
     * 获取当前车场支持的聚合支付类型
     */
    ObjectResponse<String> selectGroupPayType(String parkCode);

    /**
     * 根据车场类型查询车场集合，1：端云，2：端网云
     * @param type
     * @return
     */
    ObjectResponse<List<Park>> parkListByType(int type);

    /**
     *  查询车场是否已经满车位不让通行
     * @param parkId
     * @return
     */
    ObjectResponse<Boolean> isFullNoPass(Long parkId, String channelCode);

    /**
     * 获取车场车位信息
     * @param parkId
     * @return
     */
    ObjectResponse<ParkFreespace> getParkSpace(Long parkId);
    /**
     * 字典类型值获取
     * @return
     */
    ObjectResponse<List<DictionaryItemDto>> getDicItemList(Integer type);

    /**
     * 获取车场的出入口信息
     * @param parkId
     * @return
     */
    ObjectResponse<List<ParkInoutdevice>> getInoutByParkId(Long parkId);

    ObjectResponse<Integer> insert(ParkChargeconfig record);
    ObjectResponse<Integer> updateByPrimaryKeySelective(ParkChargeconfig record);
    ObjectResponse<Integer> deleteByPrimaryKey(Integer id);
    /**
     *
     * @param parkId
     * @param billtypecode
     * @return
     */
    ObjectResponse<ParkChargeconfig>  selectByParkIdAndBillCode( Long parkId,  String billtypecode);
    /**
     * 插入一条通道权限配置表数据
     */
    ObjectResponse<Integer> insert(ParkInoutdevice parkInoutdevice);

    /**
     * 更新一条通道权限参数配置表
     * @param parkInoutdevice
     * @return
     */
    ObjectResponse<Integer> updateAllParameter(ParkInoutdevice parkInoutdevice);

    /**
     * 删除通道权限规则
     * @param parkInoutdevice
     * @return
     */
    ObjectResponse<Integer> delInoutDeviceConfig(ParkInoutdevice parkInoutdevice);

    ObjectResponse<Integer> insertChargeDyration(ChargeDuration chargeDuration);
    ObjectResponse<Integer> delChargeDyrationRule(String billCode);
    ObjectResponse<Integer> insertChargeNaturalday(ChargeNaturalday chargeNaturalday);

    ObjectResponse<Integer> editChargeNaturalDayRule(ChargeNaturalday chargeNaturalday);

    ObjectResponse<Integer> modifyChargeNaturalDayRuleState(ChargeNaturalday chargeNaturalday);

    /**
     * 插入新的区域计费规则
     * @param regionChargeconfig
     * @return
     */
    ObjectResponse<Integer> insertRegionChargeconfigSelective(RegionChargeconfig regionChargeconfig);

    /**
     * 根据计费规则编码
     * 修改区域计费规则状态
     * @param regionChargeconfig
     * @return
     */
    ObjectResponse<Integer> modifyRegionChargeConfigStatus(RegionChargeconfig regionChargeconfig);

    /**
     * 删除区域计费规则
     * @param billtypecode
     * @return
     */
    ObjectResponse<Integer> delRegionChargeConfig(String billtypecode);
    /**
     * 根据区域id 查询区域计费
     * @param parkId
     * @return
     */
    ObjectResponse<List<RegionChargeconfig>> selectRegionChargeconfigByParkId(Long parkId);
    /**
     * 查询一组通道信息
     * @param channelIds
     * @return
     */
    ObjectResponse<List<ParkInoutdevice>> getChannelsByIds(Long[] channelIds);

    /**
     * 通过pid获取车场列表
     * @return
     */
    ObjectResponse<ParkChargeRuleVO> getParkChargeRule(Long parkId, Long regionId);


    ObjectResponse<ParkListGroup> selectByParkInfoThirdPID(String pid, Integer pageIndex, Integer pageSize);

    /**
     *
     * @param parkInfo
     * @return 车场ID
     */
    ObjectResponse<Long> insertParkInfo(ParkInfo parkInfo);
    ObjectResponse<String> updateParkInfo(ParkInfo parkInfo);
    ObjectResponse<String> selectParkInfoByParkCode(String parkCode);
    List<OrganizationTreeDto> selectParksDetails(String parkId);
    OrganizationTreeDto selectOrganizDetailsByName( String institutionName);

    /**
     * 修改车场组织为回收站机构
     * @param districtId
     * @param parkId
     * @return
     */
    Boolean updateParkInstitutionId(Integer districtId, Long parkId);

    /**
     * 删除车场信息
     * @param parkId
     * @param orgId
     * @param parkCode
     * @return
     */
    ObjectResponse<Void> deletePark(Long parkId,Integer orgId, String parkCode);

    ParkInoutdevice getChannelByCodeAndParkId(Long parkId, String inandoutCode);

    /**
     * 仅限昌平对接使用查找云岗亭管理员用户
     * @param parkId
     * @param parkCode
     * @return
     */
    List<ChangPingParkUser> getChangPingParkUser(Long parkId, String parkCode);

    /**
     * 获取车场信息
     * @param parkCode
     * @return
     */
    ObjectResponse<ParkAllInfo> getAllParkInfo(String parkCode);

    /**
     * 获取车场信息列表车位租赁
     * @param parkQuery
     * @return
     */
    ObjectResponse<Page<ParkSpaceInfo>> getParkSpaceList(ParkQuery parkQuery);

    /**
     * 获取车场位置信息访客预约
     * @param parkQuery
     * @return
     */
    ObjectResponse<Page<ParkVisitInfo>> getParkVisitList(ParkQuery parkQuery);

    ObjectResponse<List<ParkDistanceInfo>> getParkDistance(ParkDistanceParam param);

    /**
     * 模糊检索车场信息
     * @param key
     * @return
     */
    ObjectResponse<List<Park>> likeParkName(String city,String key);

    /**
     * 根据区域ID和进出口类型（非必传）查询通道
     * @param regionId 区域ID
     * @param enexType 进出类型，不传时，查询区域ID下的所有通道
     * @return 通道列表
     */
    ObjectResponse<List<ParkInoutdevice>> getInOutDevicesByRegionId(Long regionId, Integer enexType);

    /**
     * 是否场中场
     * @param parkId 车场ID
     * @return true 是, false 不是
     */
    boolean isInterior(Long parkId);


    /**
     * 通过城市名称获取城市信息
     *
     * @param name 市名称
     * @return
     */
    ObjectResponse<AreaCity> getCityBy(String name);


    /**
     * 获取车场分页
     *
     * @param pageNo   第几页
     * @param pageSize 每页展示多少条
     * @param parkName 车场名称
     * @param cityId   城市id
     * @return
     */
    ObjectResponse<Page<Park>> getParkPage(Integer pageNo, Integer pageSize, String parkName, Integer cityId);

    /**
     * 更新车场 进件状态
     * @param parkId 车场id
     * @param inputStatus 进件状态 1.未开通 3.被驳回4.已开通
     * @param payWay 支付方式
     * @return
     */
    ObjectResponse<Void> updateParkInputStatus(Long parkId, Integer inputStatus, String payWay);

    /**
     * 批量更新进件状态
     * @param statusMap <ParkId, InputStatus>
     * @return
     */
    ObjectResponse<Boolean> batchUpdateParkInputStatusByParkId(Map<Long, Integer> statusMap);


    /**
     * 获取泊斯特广告要初始化的车场
     *
     * @return
     */
    List<InitBstPark> findBstInitPark();

    /**
     * 通过车场id获取车场列表
     *
     * @param parkIds
     * @return
     */
    List<Park> findByParkIds(List<Long> parkIds);

    /**
     * 通过车场名称获取车场信息
     *
     * @param parkName
     * @return
     */
    ObjectResponse<Park> findByParkName(String parkName);

    /**
     * 获取车场连接模式
     *
     * @param parkId
     * @param parkCode
     * @return
     */
    Integer getParkDataCollection(Long parkId, String parkCode);

    /**
     * 获取区域信息
     *
     * @param districtId
     * @return
     */
    ObjectResponse<AreaDistrict> getDistrictById(Integer districtId);

    /**
     * 修改车场车位信息
     *
     * @param data
     * @return
     */
    ObjectResponse updateParkSpace(ParkFreespace data);

    List<BasePark> getParkListByParkCodes(List<String> parkCods);
}
