package com.icetech.cloudcenter.api.park;

import com.icetech.cloudcenter.domain.response.AccessInfoDto;
import com.icetech.cloudcenter.domain.response.ParkLicenseDto;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * Description : 车场license服务接口
 * @author zys
 */
public interface ParkLicenseService {
    /**
     * 根据license码查询
     * @param licenseNumber
     * @return
     */
    ObjectResponse<ParkLicenseDto> selectParkLicense(String licenseNumber);

    /**
     * license注册
     * @param parkId
     * @param licenseNumber
     * @return
     */
    ObjectResponse<ParkLicenseDto> registerParkLicense(Long parkId , String licenseNumber);

    /**
     * 根据类型获取access参数
     * @param type
     * @return
     */
    ObjectResponse<AccessInfoDto> getAccessInfoByType(int type);
}
