package com.icetech.cloudcenter.api.park;

import com.icetech.cloudcenter.domain.device.ParkDeviceInfo;
import com.icetech.basics.domain.entity.device.ProduceModel;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.device.ParkDevrecord;
import com.icetech.park.domain.entity.park.ParkCallLog;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.park.ParkChannelInfo;
import com.icetech.cloudcenter.domain.park.ParkChannelListPage;
import com.icetech.cloudcenter.domain.park.ParkInoutDeviceInfo;
import com.icetech.cloudcenter.domain.request.*;
import com.icetech.cloudcenter.domain.response.ChannelAlarmDto;
import com.icetech.cloudcenter.domain.response.DeviceListDTO;
import com.icetech.cloudcenter.domain.response.ParkCallLogDto;
import com.icetech.cloudcenter.domain.response.ParkDeviceDto;
import com.icetech.cloudcenter.domain.vo.*;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;
import java.util.Map;

/**
 * 设备服务类
 * @author wangzw
 */
public interface ParkDeviceService {


    /**
     * 根据通道查询车场云翌信息
     * @param parkId        
     * @param aisleCode
     * @return
     */
    ObjectResponse<InOutYuneasyInfoVo> getInOutYuneasyInfoVo(Long parkId, String aisleCode);
    
    /**
     * 定时更新萤石云设备状态
     * @return
     */
    ObjectResponse enDeviceStatus();
    /**
     * 视频通道设备操作
     * @param deviceCode
     * @param parkId
     * @return
     */
    ObjectResponse operation(String deviceCode,Long parkId);


    /**
     * 更新萤石云设备token 并更新到token
     * @return
     */
    ObjectResponse updateConsoleTokenForRedis(ParkDevice parkDevice);

    /**
     * 获取总条数
     * @param queryDeviceRequest
     * @return
     */
    ObjectResponse<Map<String, Object>> countDeviceAlarmList(QueryDeviceRequest queryDeviceRequest);

    /**
     * 查询设备报警
     * @param queryDeviceRequest
     * @return
     */
    ObjectResponse<List<ParkDevrecord>> getDeviceAlarmList(QueryDeviceRequest queryDeviceRequest);

    /**
     * 查询设备状态信息
     * @param queryDeviceRequest
     * @return
     */
    ObjectResponse<List<ParkDeviceDto>> getDeviceList(QueryDeviceRequest queryDeviceRequest);

    /**
     * 查询车场的某类设备列表
     * @param parkId
     * @return
     */
    ObjectResponse<List<ParkDevice>> getDeviceListByType(Long parkId, int type);

    /**
     * 设备是否都在线
     */
    ObjectResponse<Boolean> isAllOnline(Long parkId, int type, int dataCollection);

    /**
     * 查询设备详情信息
     * @param parkCode
     * @param recordId
     * @return
     */
    ObjectResponse<ParkDeviceDto> getDeviceDetail(String parkCode,Integer recordId);

    /**
     * 修改设备信息
     * @param parkId
     * @return
     */
    ObjectResponse<Void> modifyStatus(Long parkId, String deviceNo,Integer stauts, String reason, Long wrongTime);

    /**
     * 萤石云设备
     * @param maps
     * @return
     */
    ObjectResponse updateAccessToken(List<Map<String, String>> maps);

    List<ParkDevice> getDeviceListByParkId(Long parkId);

    /**
     * 根据设备类型获取设备信息
     * @return
     */
    ObjectResponse<List<ParkDevice>> getDeviceListByParkIdAndType(Long parkId, Integer type);

    /**
     *  根据通道获取设备信息
     * @param channelId
     * @param type
     * @return
     */
    ObjectResponse<List<ParkDevice>> getDeviceListByChannelId(Long channelId, Integer type);
    ObjectResponse<List<ParkDevice>> getDeviceListByChannelIds(List<Long> channelIds, Integer type);


    /**
     * 根据车场id和通道ID查询设备信息
     * @param parkId
     * @param channelId
     * @return
     */
    ObjectResponse<List<ParkDevice>> getDeviceListByParkChannelId(Long parkId, Integer channelId, int deviceType);

    /**
     * 根据区域ID获取设备信息
     * @param parkId
     * @param regionId
     * @param deviceType
     * @return
     */
    ObjectResponse<List<ParkDevice>> getDeviceListByParkRegionId(Long parkId, Integer regionId, int deviceType);

    /**
     * 上报设备状态
     * @param deviceNo
     * @param deviceType
     * @param state
     * @return
     */
    ObjectResponse reportDeviceStatus(String deviceNo,Integer deviceType,Integer state);

    /**
     * 查询当前用户设备状态信息
     * @param queryDeviceRequest
     * @return
     */
    ObjectResponse<List<ParkDeviceDto>> getUserDeviceList(QueryDeviceRequest queryDeviceRequest);
    /**
     * 查询当前用户设备条数
     * @param queryDeviceRequest
     * @return
     */
    ObjectResponse<Map<String, Object>> countUserDeviceList(QueryDeviceRequest queryDeviceRequest);
    /**
     * 获取当前用户某种类型的设备
     * @param userId
     * @param type 设备类型
     * @return
     */
    ObjectResponse<List<ParkDeviceDto>>  getDeviceByUser(Integer userId,Integer type);

    /**
     * 查询某车场某通道下的设备
     * @param parkId
     * @param channelId
     * @return
     */
    ObjectResponse<List<ParkDevice>>  getDeviceByParkChannel(Long parkId, Long channelId);
    /**
     * 根据车场ID和设备编号查询
     * @param parkId
     * @param deviceNo
     * @return
     */
    ObjectResponse<ParkDevice> getDeviceByParkIdDevice(Long parkId, String deviceNo);

    /**
     * 根据设备编号查询
     * @param serialNumber
     * @return
     */
    ObjectResponse<ParkDevice> getDeviceBySerialNumber(String serialNumber);

    /**
     * 根据通道编号获取设备列表
     * @param parkId
     * @param channelCode
     * @param type 可不传，为空时，查询所有设备
     * @return
     */
    ObjectResponse<List<ParkDevice>> getDeviceByChannel(Long parkId, String channelCode, Integer type);

    /**
     * 添加设备
     * @param parkDevice
     * @return
     */
    ObjectResponse addDevice(ParkDevice parkDevice);

    /**
     * 根据ID更新设备信息
     * @param parkDevice
     * @return
     */
    ObjectResponse updateDevice(ParkDevice parkDevice);

    ObjectResponse<ParkDevice>  selectById(ParkDevice parkDevice);

    /**
     * 查询一组通道的设备列表
     * @param parkId
     * @param channelIds
     * @param type 可不传，为空时，查询所有设备
     * @return
     */
    ObjectResponse<List<ParkDevice>> getDevicesByParkChannel(Long parkId, Long[] channelIds, Integer type);

    /**
     * 查询升级设备列表
     * @param deviceListRequest
     * @return
     */
    ObjectResponse<Page<DeviceListDTO>> upgradeDeviceList(DeviceListRequest deviceListRequest);

    /**
     * 获取通道信息
     * @param parkCodeList
     * @return
     */
    ObjectResponse<ParkChannelListPage<ParkChannelInfo>> selectByParkCode(List<String> parkCodeList, Integer pageIndex, Integer pageSize);
    ObjectResponse<ParkChannelListPage<ParkInoutDeviceInfo>> selectChannelInfoByParkCode(String parkCode, Integer pageIndex, Integer pageSize);


    ObjectResponse<ParkChannelListPage<ParkChannelInfo>> selectParkChannelInfoByParkId(List<Integer> parkIdList, Integer pageIndex, Integer pageSize);

    ObjectResponse<ParkInoutdevice> selectParkInoutdeviceByChannelCode(String channelCode);

    ObjectResponse<ParkChannelListPage<ParkDeviceInfo>> selectDeviceInfoSimpleList(List<Integer> parkId, List<Integer> statusList, Integer pageIndex, Integer pageSize);

    ObjectResponse<ParkInoutdevice> createChannel(ParkInoutdevice parkDevice);
    ObjectResponse<ParkInoutdevice> updateChannel(ParkInoutdevice parkDevice);

    ObjectResponse<ParkDevice> createParkDevice(ParkInoutdevice parkInoutdevice ,ParkDevice parkDevice);
    ObjectResponse<Integer> updateParkDevice(ParkDevice parkDevice);

    /**
     *  通过sn查询设备详情信息
     * @param serialNumber sn
     * @return ParkDeviceVo
     */
    ObjectResponse<ParkDeviceVo> getParkDeviceVo(String serialNumber);

    /**
     * 查询设备和支持功能的对应关系
     * @return
     */
    ObjectResponse<List<ProduceModel>> getProduceModelList();


    ParkDevice getDeviceByParkIdAndChannelId(Long parkId, Long channelId);

    /**
     * 设备状态变更处理
     * @param serialNumber
     * @param eventTime
     * @param status
     * @param deviceType
     * @return
     */
    ObjectResponse deviceStatusUpdate(String serialNumber, Long eventTime,
                                      Integer status, Integer deviceType);
}
