package com.icetech.cloudcenter.api.park;

import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipParam;
import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipRecordParam;
import com.icetech.cloudcenter.domain.response.ParkTrusteeshipRecordPage;
import com.icetech.cloudcenter.domain.vo.ParkTrusteeshipVo;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.dto.ParkTrusteeshipDto;
import com.icetech.park.domain.dto.ParkTrusteeshipRecordDto;
import com.icetech.park.domain.entity.ParkTrusteeship;

/**
 * Description IParkTrusteeshipService
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/6/28 15:22
 */
public interface IParkTrusteeshipService {

    /**
     * Description: 开通车场托管服务
     * Version1.0 2023-06-28 by wgy 创建
     * 
     * @param parkTrusteeshipVo 参数
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Boolean>       
     */
    ObjectResponse<Boolean> openParkTrusteeship(ParkTrusteeshipVo parkTrusteeshipVo);
    
    /**
     * Description: 续费车场服务
     * Version1.0 2023-06-28 by wgy 创建
     * 
     * @param parkTrusteeshipVo     参数
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Boolean>       
     */
    ObjectResponse<Boolean> renewParkTrusteeship(ParkTrusteeshipVo parkTrusteeshipVo);
    
    /**
     * Description: 查询托管记录
     * Version1.0 2023-06-29 by wgy 创建
     * 
     * @param parkTrusteeshipParam 参数
     * @return com.icetech.common.domain.response.ObjectResponse<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.icetech.cloudcenter.domain.dto.ParkTrusteeshipDto>>       
     */
    ObjectResponse<Page<ParkTrusteeshipDto>> searchParkTrusteeship(ParkTrusteeshipParam parkTrusteeshipParam);
    
    /**
     * Description: 查询托管缴费记录
     * Version1.0 2023-06-29 by wgy 创建
     * 
     * @param parkTrusteeshipRecordParam    参数
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.common.domain.Page<com.icetech.cloudcenter.domain.dto.ParkTrusteeshipRecordDto>>       
     */
    ObjectResponse<ParkTrusteeshipRecordPage<ParkTrusteeshipRecordDto>> searchParkTrusteeshipRecord(ParkTrusteeshipRecordParam parkTrusteeshipRecordParam);

    /**
     * Description: 通过车场 id 获取托管信息
     * Version1.0 2023-07-24 by wgy 创建
     * 
     * @param parkId    车场 id
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.cloudcenter.domain.entity.ParkTrusteeship>       
     */
    ObjectResponse<ParkTrusteeship> getParkTrusteeshipByParkId(Long parkId);
}
