package com.icetech.cloudcenter.api.order;

import com.icetech.cloudcenter.domain.response.WorkRecordDto;
import com.icetech.cloudcenter.domain.response.WorkReportDto;
import com.icetech.common.domain.response.ObjectResponse;

public interface OrderMoneyService {
    /**
     * 添加云岗厅小程序车场用户交接班记录表
     */
    ObjectResponse addWorkReports(Integer userId);

    /**
     * 获取当前登陆人员的车场的实收现金
     */
    ObjectResponse<WorkRecordDto> getParkReportMoney(Integer userId, String parkCode);

    /**
     * 现金结账
     */
    ObjectResponse settleAccounts(Integer userId, String parkCode, String endTime, Integer from);

    /**
     * 获取当班人员信息
     * @param userId
     * @param parkId
     * @return
     */
    ObjectResponse<WorkReportDto> getWorkReport(Integer userId, Long parkId);

    /**
     * 添加关联记录表
     * @param reportId
     * @param orderPayId
     * @return
     */
    ObjectResponse addOrderMoney(Integer reportId, Long orderPayId);
}
