package com.icetech.cloudcenter.api.order;

import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.Map;

/**
 * Description : 车辆进场服务接口
 * @author fangct
 */
public interface CarOrderExitService {

    /**
     * 车辆进场业务
     * @param exitRequest 离场参数
     * @return 响应订单号
     */
    default ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest) {
        return ObjectResponse.success();
    }

    /**
     * 异常离场
     * @param exitRequest 离场参数
     * @param oddStatus 异常原因
     * @return 响应订单号
     */
    default ObjectResponse<Map<String, Object>> exceptionExit(CarExitRequest exitRequest, Integer oddStatus) {
        return ObjectResponse.success();
    }

    /**
     *
     * @param exitRequest 离场参数
     * @param payStatus 支付状态
     */
    void sendWebsocketMessage(CarExitRequest exitRequest, String payStatus,Integer allow,Integer needPay);
}
