package com.icetech.cloudcenter.api.month;

import com.icetech.fee.domain.entity.vip.VipInfo;
import com.icetech.fee.domain.vo.VipInfoDetail;
import com.icetech.cloudcenter.domain.response.VipInfoDto;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.fee.domain.entity.vip.VipPlate;
import com.icetech.fee.domain.entity.vip.VipRecord;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * vip 车辆服务
 */
public interface VipCarService {

    /**
     * 验证当前车辆是不是VIP车辆(有效期)
     */
    ObjectResponse<VipType> getValidVipCar(Long parkId, String plateNum, Long regionId);

    /**
     * 验证当前车辆最近的一次VIP信息
     */

    ObjectResponse<VipType> getRecentVipCar(Long parkId, String plateNum, Long regionId);

    /**
     * 根据ID查询VIP操作记录
     * @param id
     * @return
     */
    ObjectResponse<VipRecord> getOperatorRecordById(Long id);

    /**
     * 查询有效VIP信息，暂时只查全免类型
     * @param parkId
     * @return
     */
    ObjectResponse<List<VipInfoDto>> getValidByParkId(Long parkId);
    ObjectResponse<List<VipInfoDto>> getValidByIds(List<String> idList);

    /**
     * 获取VIP类型信息
     * @param typeId
     * @return
     */
    ObjectResponse<VipTypeDto> getVipTypeById(Integer typeId);

    /**
     * 获取VIP信息
     * @param vipInfoId VIP信息ID
     * @return
     */
    ObjectResponse<VipInfoDetail> getVipInfoDetailById(int vipInfoId);

    /**
     * 获取VIP车辆列表
     * @param vipInfoId VIP信息ID
     * @return
     */
    ObjectResponse<List<VipPlate>> getVipPlatesByInfoId(long vipInfoId);

    /**
     * 通过id列表 查询操作记录ID列表
     * @param ids
     * @return
     */
    ObjectResponse<List<Long>> getRecordIdListByIds(List<Long> ids);
    /**
     * 获取VIP类型信息
     * @param parkId
     * @return
     */
    ObjectResponse<List<VipTypeDto>> getVipTypeByParkId(Long parkId);

    /**
     * 通过车场id获取全免类型vip
     *
     * @param parkId
     * @return
     */
    ObjectResponse<VipType> getVipFeeTypeByParkId(Long parkId);

    /**
     * 添加vip 类型
     *
     * @param vipType
     * @return
     */
    ObjectResponse<Boolean> addVipType(VipType vipType);

    /**
     * 通过车场id和vipId获取vip信息
     *
     * @param parkId
     * @param vipId
     * @return
     */
    ObjectResponse<VipInfo> getVipInfoByParkIdAndTypeId(Long parkId, Integer vipId);

    /**
     * 添加vip信息
     *
     * @param vipInfo
     * @return
     */
    ObjectResponse<Boolean> addVipInfo(VipInfo vipInfo);

    /**
     * 添加vip操作记录
     *
     * @param vipRecord
     * @return
     */
    ObjectResponse<Boolean> addVipRecord(VipRecord vipRecord);


    /**
     * 修改vipInfo
     *
     * @param vipInfo
     * @return
     */
    ObjectResponse<Boolean> updateVipInfo(VipInfo vipInfo);

    List<VipRecord> getVipRecordsByVipId(Integer parkId, Integer vipId);
}
