package com.icetech.cloudcenter.api.invoice;

import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.response.InvoiceDetailResponse;
import com.icetech.cloudcenter.domain.response.InvoiceRecordResponse;
import com.icetech.park.domain.entity.invoice.InvoiceMerchant;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

public interface InvoiceMerchantService {
    int deleteByPrimaryKey(Integer id);

    InvoiceMerchant insert(InvoiceMerchant record);

    InvoiceMerchant selectByPrimaryKey(Integer id);

    InvoiceMerchant selectByParkId(Long parkId);

    int updateByTaxpayerInfo(InvoiceMerchant record);

    InvoiceMerchant selectByTaxnum(String taxpayerNum);

    /**
     * 获取公众号用户的发票记录
     */
    ObjectResponse<List<InvoiceRecordResponse>> getInvoiceRecords(Integer mpUserId, BaseQueryRequest baseQueryRequest,Integer source);

    /**
     * 根据订单号获取开票详情
     */
    ObjectResponse<InvoiceDetailResponse> getInvoiceDetail(String orderId);

}
