package com.icetech.cloudcenter.api.invoice;


import com.icetech.cloudcenter.domain.response.InvoiceDetailResponse;
import com.icetech.cloudcenter.domain.response.InvoiceRecordResponse;
import com.icetech.park.domain.entity.invoice.InvoiceBlue;

import java.util.Date;
import java.util.List;


public interface InvoiceBlueService {
    int deleteByPrimaryKey(Integer id);

    InvoiceBlue insert(InvoiceBlue record);

    InvoiceBlue selectByOrderId(String orderId);

    int updateByOrderId(InvoiceBlue record);

    /**
     * 获取 公众号下的所有开票记录
     * @param mpUserId
     * @param startTime
     * @param endTime
     * @return
     */
    List<InvoiceRecordResponse> selectByMpUserId(Integer mpUserId, Date startTime, Date endTime,Integer source);

    /**
     * 获取订单发票明细的返回
     * @param orderId
     * @return
     */
    InvoiceDetailResponse selectInvoiceDetailByOrderId(String orderId);

    /**
     * 根据订单号删除
     * @param orderId
     */
    int deleteByOrderId(String orderId);

    /**
     * 第三方订单号获取开票信息
     * @param thirdId
     * @return
     */
    InvoiceBlue selectByThirdId(String thirdId);

    /**
     * 根据开票渠道和状态获取开票列表
     * @param channel
     * @param status
     * @return
     */
    List<InvoiceBlue> selectByChannelAndStatus( Integer channel, Integer status);

    /**
     *
     * @param source
     * @param plateNum
     * @param plateNumList
     * @return
     */
    List<String> selectCheckedTradeNoList(Integer source,String plateNum, List<String> plateNumList);

}
