package com.icetech.cloudcenter.api.fee;

import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.pnc.EtcPayStatusRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.pnc.EtcPayStatusResponse;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * Description : 订单查询费用接口
 * @author fangct
 */
public interface QueryOrderFeeService {

    /**
     * 查询订单费用
     * @param queryOrderFeeRequest 参数
     * @return 响应费用
     */
    ObjectResponse<QueryOrderFeeResponse> queryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest);

    /**
     * 查询附带欠费的费用信息
     * @param queryOrderFeeRequest 参数
     * @return 附带欠费的费用信息
     */
    ObjectResponse<QueryOrderFeeResponse> queryOrderFeeWithNotPay(QueryOrderFeeRequest queryOrderFeeRequest);

    /**
     * 更新欠费订单费用
     * @param parkCode 车场编号
     * @param channelCode 通道编号
     * @param plateNum 车牌号
     * @param notPayOrderNums 欠费订单列表
     * @return 最新费用
     */
    ObjectResponse<QueryOrderFeeResponse> updateAndGetChannelFee(String parkCode, String channelCode, String plateNum, List<String> notPayOrderNums);

    /**
     * ETC
     * @param queryOrderFeeRequest
     * @param parkId
     * @param topic
     * @return
     */
    ObjectResponse<EtcPayStatusResponse> etcPayStatus(EtcPayStatusRequest queryOrderFeeRequest, Long parkId, String topic);


}
