package com.icetech.cloudcenter.api.discount;

import com.icetech.cloudcenter.domain.pay.MerchantRechargeDto;
import com.icetech.cloudcenter.domain.response.MerchantDto;
import com.icetech.cloudcenter.domain.response.MerchantUserDto;
import com.icetech.common.domain.response.ObjectResponse;

import java.math.BigDecimal;

/**
 * 商户用户类
 * @author wangzw
 */
public interface MerchantUserService {

    /**
     * 商户登陆服务 登陆成功之后返回商户信息
     * @param loginName
     * @param password
     * @param newPwd
     * @return
     */
    ObjectResponse<MerchantUserDto> login(String loginName,String password, String newPwd);

    /**
     *查询商户信息
     * @param merchantId
     * @return
     */
    ObjectResponse<MerchantDto> findMerchant(Integer merchantId);

    /**
     * 根据商户编码查询
     * @param merchantCode
     * @return
     */
    ObjectResponse<MerchantDto> findMerchantByCode(String merchantCode);

    /**
     * 修改密码
     * @param userId
     * @param oldPwd
     * @param newPwd
     * @return
     */
    ObjectResponse modifyPwd(Integer userId, String oldPwd, String newPwd);

    /**
     * 修改头像
     * @param userId
     * @param photoPath
     * @return
     */
    ObjectResponse modifyPhoto(Integer userId, String photoPath);

    /**
     * 扣减商户余额
     * @return
     */
    ObjectResponse<Void> subMerchantMoney(Integer merchantId, BigDecimal bigDecimal);

    /**
     * 商户余额新增
     * @param merchantId
     * @param bigDecimal
     * @return
     */
    ObjectResponse<Void> addMerchantMoney(Integer merchantId, BigDecimal bigDecimal);

    /**
     * 完成商户充值
     * @param dto
     * @return
     */
    ObjectResponse<Void> finishRecharge(MerchantRechargeDto dto);

    /**
     * 查询交易结果
     * @param tradeNo
     * @return
     */
    ObjectResponse<Void> orderResult(String tradeNo);


}
