/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.exception;

import com.alibaba.fastjson.JSON;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.web.bean.ServiceConfig;
import com.icetech.web.bean.ServiceContext;
import com.icetech.web.exception.ServiceException;
import com.icetech.web.message.ServiceErrorEnum;
import com.icetech.web.message.ServiceErrorFactory;
import com.icetech.web.result.ServiceResultBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.util.UriUtils;

public class ExceptionHolder {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHolder.class);
    private static final int BIZ_ERROR_CODE = 4000;
    private static final int SYSTEM_ERROR_CODE = 5050;
    private static final String X_SERVICE_ERROR_HEADER_NAME = "x-service-error-code";
    private static final String X_SERVICE_ERROR_MESSAGE = "x-service-error-message";
    private static final String X_SERVICE_ERROR_RESPONSE = "x-service-error-response";
    private static final String LEFT_TOKEN = "{";
    private static final String RIGHT_TOKEN = "}";
    private static final String EQ = "=";
    private static final String COMMA = ",";
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];

    public static void hold(HttpServletRequest request, HttpServletResponse response, Exception exception) {
        if (exception instanceof ResponseBodyException) {
            ResponseBodyException responseBodyException = (ResponseBodyException)exception;
            exception = new ServiceException(responseBodyException.getErrCode(), responseBodyException.getMessage());
            log.warn("\u4e1a\u52a1\u9519\u8bef", (Throwable)exception);
        } else {
            log.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)exception);
        }
        int code = exception instanceof ServiceException ? 4000 : 5050;
        response.setHeader(X_SERVICE_ERROR_HEADER_NAME, String.valueOf(code));
        String responseBody = ExceptionHolder.buildResponse(request, response, exception);
        response.setHeader(X_SERVICE_ERROR_RESPONSE, UriUtils.encode((String)responseBody, (Charset)StandardCharsets.UTF_8));
        if (code == 5050) {
            if (exception instanceof HttpRequestMethodNotSupportedException) {
                responseBody = ExceptionHolder.buildResponse(request, response, ServiceErrorEnum.ISV_METHOD_NOT_ALLOWED.getErrorMeta().getException(new Object[0]));
                response.setHeader(X_SERVICE_ERROR_RESPONSE, UriUtils.encode((String)responseBody, (Charset)StandardCharsets.UTF_8));
                return;
            }
            if (exception instanceof BindException) {
                BindingResult bindingResult = ((BindException)exception).getBindingResult();
                ServiceException serviceException = ExceptionHolder.getValidateBizParamException(bindingResult.getFieldError().getDefaultMessage());
                responseBody = ExceptionHolder.buildResponse(request, response, serviceException);
                response.setHeader(X_SERVICE_ERROR_RESPONSE, UriUtils.encode((String)responseBody, (Charset)StandardCharsets.UTF_8));
                return;
            }
            if (exception instanceof ConstraintViolationException) {
                String message = null;
                Optional optional = ((ConstraintViolationException)exception).getConstraintViolations().stream().findFirst();
                if (optional.isPresent()) {
                    ConstraintViolation constraintViolation = (ConstraintViolation)optional.get();
                    message = constraintViolation.getMessage();
                }
                ServiceException serviceException = ExceptionHolder.getValidateBizParamException(Objects.requireNonNull(message));
                responseBody = ExceptionHolder.buildResponse(request, response, serviceException);
                response.setHeader(X_SERVICE_ERROR_RESPONSE, UriUtils.encode((String)responseBody, (Charset)StandardCharsets.UTF_8));
                return;
            }
            if (exception instanceof MethodArgumentNotValidException) {
                BindingResult bindingResult = ((MethodArgumentNotValidException)exception).getBindingResult();
                String message = bindingResult.getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "));
                ServiceException serviceException = ExceptionHolder.getValidateBizParamException(Objects.requireNonNull(message));
                responseBody = ExceptionHolder.buildResponse(request, response, serviceException);
                response.setHeader(X_SERVICE_ERROR_RESPONSE, UriUtils.encode((String)responseBody, (Charset)StandardCharsets.UTF_8));
                return;
            }
            StringBuilder msg = new StringBuilder();
            msg.append(exception.getMessage());
            StackTraceElement[] stackTrace = exception.getStackTrace();
            int lineCount = 5;
            for (int i = 0; i < stackTrace.length && i < lineCount; ++i) {
                StackTraceElement stackTraceElement = stackTrace[i];
                msg.append("\n at ").append(stackTraceElement.toString());
            }
            response.setHeader(X_SERVICE_ERROR_MESSAGE, UriUtils.encode((String)msg.toString(), (Charset)StandardCharsets.UTF_8));
        }
    }

    private static String buildResponse(HttpServletRequest request, HttpServletResponse response, Exception exception) {
        ServiceResultBuilder serviceResultBuilder = ServiceConfig.getInstance().getServiceResultBuilder();
        Object result = serviceResultBuilder.buildError(request, response, exception);
        return JSON.toJSONString((Object)result);
    }

    public static ServiceException getValidateBizParamException(String errorMsg) {
        String subCode = ServiceErrorEnum.ISV_PARAM_ERROR.getErrorMeta().getSubCode();
        String[] msgToken = errorMsg.split(EQ);
        String msg = msgToken[0];
        if (msg.startsWith(LEFT_TOKEN) && msg.endsWith(RIGHT_TOKEN)) {
            String module = msg.substring(1, msg.length() - 1);
            Object[] params = ExceptionHolder.buildParams(msgToken);
            String error = ServiceErrorFactory.getErrorMessage(module, ServiceContext.getCurrentContext().getLocale(), params);
            return new ServiceException(subCode, error);
        }
        return new ServiceException(subCode, errorMsg);
    }

    private static Object[] buildParams(String[] msgToken) {
        if (msgToken.length == 2) {
            return msgToken[1].split(COMMA);
        }
        return EMPTY_OBJ_ARRAY;
    }
}

