package com.icetech.web.swagger;

import com.google.common.collect.Lists;
import com.icetech.common.utils.IpUtils;
import com.icetech.mq.constants.Constant;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.web.bean.DocInfo;
import io.swagger.models.Swagger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

import java.net.UnknownHostException;

/**
 * Description SwaggerDocRun
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/12/22 9:55 上午
 */
@Slf4j
public class SwaggerDocRun implements ApplicationRunner {

    @Autowired
    private RabbitSender rabbitSender;

    @Autowired
    private DocumentationCache documentationCache;

    @Autowired
    private ServiceModelToSwagger2Mapper mapper;

    @Autowired
    private JsonSerializer jsonSerializer;

    @Value("${ice.route.scan:false}")
    private boolean routeScan;

    @Value("${spring.application.name}")
    private String serviceId;

    @Value("${server.port}")
    private String port;

    @Override
    public void run(ApplicationArguments args) throws UnknownHostException {
        if (!routeScan) {
            return;
        }
        String groupName = Docket.DEFAULT_GROUP_NAME;
        Documentation documentation = documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return;
        }
        Swagger swagger = mapper.mapDocumentation(documentation);
        DocInfo docInfo = DocInfo.builder().serviceId(serviceId).ip(IpUtils.getLocalHostLANAddress().getHostAddress()).port(port).docJson(jsonSerializer.toJson(swagger).value()).build();
        rabbitSender.sendMessage("", Constant.COMMON_DOCUMENT_SCAN_QUEUE, docInfo, 0L, Lists.newArrayList(Constant.platformMq));
    }
}
