/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.wrapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderMapRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(HeaderMapRequestWrapper.class);
    private Map<String, String> headerMap = new HashMap<String, String>();

    public HeaderMapRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public String getHeader(String name) {
        log.info("getHeader --->{}", (Object)name);
        String headerValue = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            headerValue = this.headerMap.get(name);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList names = Collections.list(super.getHeaderNames());
        for (String name : this.headerMap.keySet()) {
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        log.info("getHeaders --->>>>>>{}", (Object)name);
        List<Object> values = Collections.list(super.getHeaders(name));
        log.info("getHeaders --->>>>>>{}", values);
        if (this.headerMap.containsKey(name)) {
            log.info("getHeaders --->{}", (Object)this.headerMap.get(name));
            values = Arrays.asList(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }
}

