/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

public class OpenUtil {
    private static final Logger log = LoggerFactory.getLogger(OpenUtil.class);
    public static final String MULTIPART = "multipart/";

    public static Map<String, Object> parseQueryToMap(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        String[] queryList = StringUtils.split((String)query, (char)'&');
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        for (String param : queryList) {
            String[] paramArr = param.split("\\=");
            if (paramArr.length == 2) {
                try {
                    params.put(paramArr[0], URLDecoder.decode(paramArr[1], "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (paramArr.length != 1) continue;
            params.put(paramArr[0], "");
        }
        return params;
    }

    public static JSONObject getRequestParams(HttpServletRequest request) {
        JSONObject jsonObject;
        block6: {
            String contentType = request.getContentType();
            if (contentType == null) {
                contentType = "";
            }
            contentType = contentType.toLowerCase();
            if (StringUtils.containsAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"application/json", "text/plain"})) {
                try {
                    String requestJson = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    if (StringUtils.isBlank((CharSequence)requestJson)) {
                        jsonObject = new JSONObject();
                        break block6;
                    }
                    jsonObject = JSON.parseObject((String)requestJson);
                }
                catch (Exception e) {
                    jsonObject = new JSONObject();
                    log.error("\u83b7\u53d6\u6587\u672c\u6570\u636e\u6d41\u5931\u8d25", (Throwable)e);
                }
            } else {
                Map<String, Object> params = OpenUtil.convertRequestParamsToMap(request);
                jsonObject = new JSONObject(params);
            }
        }
        return jsonObject;
    }

    public static Map<String, Object> convertRequestParamsToMap(HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        if (paramMap == null || paramMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(paramMap.size());
        Set entrySet = paramMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length < 1) continue;
            retMap.put(name, values[0]);
        }
        return retMap;
    }

    public static boolean validateSimpleSign(HttpServletRequest request, String secret) {
        String time = request.getParameter("time");
        String sign = request.getParameter("sign");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{time, sign})) {
            return false;
        }
        String source = secret + time + secret;
        String serverSign = DigestUtils.md5DigestAsHex((byte[])source.getBytes());
        return serverSign.equals(sign);
    }

    public static boolean isMultipart(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }
}

