/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.swagger;

import com.icetech.web.swagger.CustomModelToSwaggerMapper;
import com.icetech.web.swagger.CustomSwaggerParameterBuilder;
import com.icetech.web.swagger.DocumentationPluginsManagerExt;
import com.icetech.web.swagger.SwaggerSecurityFilter;
import io.swagger.annotations.ApiOperation;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.spring.web.plugins.Docket;

public abstract class SwaggerSupport {
    protected abstract String getDocTitle();

    @Bean
    @Primary
    public DocumentationPluginsManagerExt documentationPluginsManagerExt() {
        return new DocumentationPluginsManagerExt();
    }

    @Bean
    @Primary
    public CustomModelToSwaggerMapper customModelToSwaggerMapper() {
        return new CustomModelToSwaggerMapper();
    }

    @Bean
    @Primary
    public CustomSwaggerParameterBuilder customSwaggerParameterBuilder(DescriptionResolver descriptions, EnumTypeDeterminer enumTypeDeterminer) {
        return new CustomSwaggerParameterBuilder(descriptions, enumTypeDeterminer);
    }

    @Bean
    public Docket createRestApi() {
        return this.getDocket();
    }

    protected Docket getDocket() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build();
    }

    @Bean
    public SwaggerSecurityFilter swaggerSecurityFilter() {
        return new SwaggerSecurityFilter(this.swaggerAccessProtected());
    }

    protected boolean swaggerAccessProtected() {
        return true;
    }

    protected ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.getDocTitle()).description("\u6587\u6863\u63cf\u8ff0").termsOfServiceUrl("\u6587\u6863").version("1.0").build();
    }
}

