/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.filter;

import com.icetech.web.wrapper.HttpServletRequestDecorator;
import com.icetech.web.wrapper.HttpServletResponseDecorator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class WrapperServletRequestFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WrapperServletRequestFilter.class);

    public void init(FilterConfig filterConfig) {
        logger.info("Init web filter...");
        logger.info("Init web filter success!");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("webFilter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            httpRequest = this.wrapRequest(httpRequest);
            HttpServletResponseDecorator respDecorator = this.wrapResponse(httpResponse);
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)respDecorator);
            respDecorator.copyBodyToResponse();
        }
        catch (Exception e) {
            logger.error("ApiWebFilter error", (Throwable)e);
        }
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) throws IOException {
        if (!(request instanceof HttpServletRequestDecorator)) {
            return new HttpServletRequestDecorator(request);
        }
        return request;
    }

    private HttpServletResponseDecorator wrapResponse(HttpServletResponse response) {
        if (!(response instanceof HttpServletResponseDecorator)) {
            return new HttpServletResponseDecorator(response);
        }
        return (HttpServletResponseDecorator)response;
    }

    public void destroy() {
        logger.info("Destroy web filter success!");
    }
}

