/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.bean;

import com.icetech.web.bean.OpenContext;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServiceContext
extends ConcurrentHashMap<String, Object> {
    public static final String REQUEST_KEY = "ice-request";
    public static final String RESPONSE_KEY = "ice-response";
    public static final String OPEN_CONTEXT_KEY = "ice-open-context";
    protected static Class<? extends ServiceContext> contextClass = ServiceContext.class;
    protected static final ThreadLocal<? extends ServiceContext> THREAD_LOCAL = new ThreadLocal<ServiceContext>(){

        @Override
        protected ServiceContext initialValue() {
            try {
                return contextClass.newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    };

    public void setOpenContext(OpenContext openContext) {
        this.set(OPEN_CONTEXT_KEY, openContext);
    }

    public OpenContext getOpenContext() {
        return (OpenContext)this.get(OPEN_CONTEXT_KEY);
    }

    public Locale getLocale() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return request.getLocale();
    }

    public static void setContextClass(Class<? extends ServiceContext> clazz) {
        contextClass = clazz;
    }

    public static ServiceContext getCurrentContext() {
        return THREAD_LOCAL.get();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultResponse) {
        Boolean b = (Boolean)this.get(key);
        if (b != null) {
            return b;
        }
        return defaultResponse;
    }

    public void set(String key) {
        this.put(key, Boolean.TRUE);
    }

    public void set(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.get(REQUEST_KEY);
    }

    public void setRequest(HttpServletRequest request) {
        this.put(REQUEST_KEY, request);
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.get(RESPONSE_KEY);
    }

    public void setResponse(HttpServletResponse response) {
        this.set(RESPONSE_KEY, response);
    }

    public void unset() {
        THREAD_LOCAL.remove();
    }
}

