/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.aop;

import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.web.aop.anno.TimeoutWarning;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TimeoutWarningAop {
    private static final Logger log = LoggerFactory.getLogger(TimeoutWarningAop.class);

    @Pointcut(value="@annotation(com.icetech.web.aop.anno.TimeoutWarning)")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object process(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        try {
            Object object = joinPoint.proceed(joinPoint.getArgs());
            return object;
        }
        finally {
            this.loggingWarn(joinPoint, System.currentTimeMillis() - startTime);
        }
    }

    private void loggingWarn(ProceedingJoinPoint joinPoint, long elapsedTime) {
        try {
            MethodSignature methodSignature;
            TimeoutWarning warning;
            long timeout = 5000L;
            LogWarnTypeEnum warnType = TimeoutWarning.DEFAULT_WARN_TYPE;
            String message = null;
            String content = null;
            Object[] contentArgs = null;
            Signature signature = joinPoint.getSignature();
            if (signature instanceof MethodSignature && (warning = (methodSignature = (MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(TimeoutWarning.class)) != null) {
                warnType = warning.warnType();
                message = warning.message();
                content = warning.content();
                contentArgs = warning.contentArgs();
            }
            if (elapsedTime > timeout) {
                if (StringUtils.isBlank(content)) {
                    content = "[\u76d1\u63a7\u57cb\u70b9] alarmType[{}] {}: {}";
                    contentArgs = new Object[]{warnType, message, elapsedTime};
                }
                log.warn(content, contentArgs);
            }
        }
        catch (Exception e) {
            log.error("\u8d85\u65f6\u76d1\u63a7\u57cb\u70b9\u65e5\u5fd7\u8f93\u51fa\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

