/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.swagger;

import com.google.common.collect.Lists;
import com.icetech.common.utils.IpUtils;
import com.icetech.mq.constants.Constant;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.web.bean.DocInfo;
import io.swagger.models.Swagger;
import java.net.UnknownHostException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

public class SwaggerDocRun
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SwaggerDocRun.class);
    @Autowired
    private RabbitSender rabbitSender;
    @Autowired
    private DocumentationCache documentationCache;
    @Autowired
    private ServiceModelToSwagger2Mapper mapper;
    @Autowired
    private JsonSerializer jsonSerializer;
    @Value(value="${ice.route.scan:false}")
    private boolean routeScan;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.port}")
    private String port;

    public void run(ApplicationArguments args) throws UnknownHostException {
        if (!this.routeScan) {
            return;
        }
        String groupName = "default";
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return;
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        DocInfo docInfo = DocInfo.builder().serviceId(this.serviceId).ip(IpUtils.getLocalHostLANAddress().getHostAddress()).port(this.port).docJson(this.jsonSerializer.toJson((Object)swagger).value()).build();
        this.rabbitSender.sendMessage("", "common.document.scan.queue", (Object)docInfo, Long.valueOf(0L), (Collection)Lists.newArrayList((Object[])new String[]{Constant.platformMq}));
    }
}

