/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.swagger;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.validator.constraints.Length;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

public class CustomSwaggerParameterBuilder
implements ExpandedParameterBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final EnumTypeDeterminer enumTypeDeterminer;

    public CustomSwaggerParameterBuilder(DescriptionResolver descriptions, EnumTypeDeterminer enumTypeDeterminer) {
        this.descriptions = descriptions;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public void apply(ParameterExpansionContext context) {
        Optional apiParamOptional;
        Optional apiModelPropertyOptional = context.findAnnotation(ApiModelProperty.class);
        if (apiModelPropertyOptional.isPresent()) {
            this.fromApiModelProperty(context, (ApiModelProperty)apiModelPropertyOptional.get());
        }
        if ((apiParamOptional = context.findAnnotation(ApiParam.class)).isPresent()) {
            this.fromApiParam(context, (ApiParam)apiParamOptional.get());
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }

    private void fromApiParam(ParameterExpansionContext context, ApiParam apiParam) {
        String allowableProperty = Strings.emptyToNull((String)apiParam.allowableValues());
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.fromNullable((Object)allowableProperty), context.getFieldType().getErasedType());
        this.maybeSetParameterName(context, apiParam.name()).description(this.descriptions.resolve(apiParam.value())).defaultValue(apiParam.defaultValue()).required(apiParam.required()).allowMultiple(apiParam.allowMultiple()).allowableValues(allowable).parameterAccess(apiParam.access()).hidden(apiParam.hidden()).scalarExample((Object)apiParam.example()).complexExamples(Examples.examples((Example)apiParam.examples())).order(-2147482648).vendorExtensions(this.getVendorExtension(context)).build();
    }

    private void fromApiModelProperty(ParameterExpansionContext context, ApiModelProperty apiModelProperty) {
        String allowableProperty = Strings.emptyToNull((String)apiModelProperty.allowableValues());
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.fromNullable((Object)allowableProperty), context.getFieldType().getErasedType());
        this.maybeSetParameterName(context, apiModelProperty.name()).description(this.descriptions.resolve(apiModelProperty.value())).required(apiModelProperty.required()).allowableValues(allowable).parameterAccess(apiModelProperty.access()).hidden(apiModelProperty.hidden()).scalarExample((Object)apiModelProperty.example()).order(apiModelProperty.position()).vendorExtensions(this.getVendorExtension(context)).build();
    }

    private List<VendorExtension> getVendorExtension(ParameterExpansionContext context) {
        ArrayList<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>(4);
        Optional annotation = context.findAnnotation(Length.class);
        if (annotation.isPresent()) {
            Length length = (Length)annotation.get();
            vendorExtensions.add((VendorExtension)new StringVendorExtension("maxLength", String.valueOf(length.max())));
            vendorExtensions.add((VendorExtension)new StringVendorExtension("minLength", String.valueOf(length.min())));
        }
        return vendorExtensions;
    }

    private ParameterBuilder maybeSetParameterName(ParameterExpansionContext context, String parameterName) {
        if (!Strings.isNullOrEmpty((String)parameterName)) {
            context.getParameterBuilder().name(parameterName);
        }
        return context.getParameterBuilder();
    }

    private AllowableValues allowableValues(Optional<String> optionalAllowable, Class<?> fieldType) {
        AllowableListValues allowable = null;
        if (this.enumTypeDeterminer.isEnum(fieldType)) {
            allowable = new AllowableListValues(this.getEnumValues(fieldType), "LIST");
        } else if (optionalAllowable.isPresent()) {
            allowable = ApiModelProperties.allowableValueFromString((String)((String)optionalAllowable.get()));
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

